/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.spring.AbstractSpringConfigurationFactory;
import org.apache.cxf.jaxrs.spring.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.cxf.jaxrs.spring.SpringResourceFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;

@ComponentScan(includeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={ApplicationPath.class, Path.class, javax.ws.rs.ext.Provider.class, Provider.class})})
public abstract class AbstractSpringComponentScanServer
extends AbstractSpringConfigurationFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSpringComponentScanServer.class);
    @Value(value="${cxf.jaxrs.classes-scan-packages:}")
    private String classesScanPackages;
    @Value(value="${cxf.jaxrs.component-scan-packages:}")
    private String componentScanPackages;
    @Value(value="${cxf.jaxrs.component-scan-beans:}")
    private String componentScanBeans;
    private List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    private List<Object> jaxrsProviders = new LinkedList<Object>();
    private List<Feature> cxfFeatures = new LinkedList<Feature>();
    private Class<? extends Annotation> serviceAnnotation;

    protected AbstractSpringComponentScanServer() {
    }

    protected AbstractSpringComponentScanServer(Class<? extends Annotation> serviceAnnotation) {
        this.serviceAnnotation = serviceAnnotation;
    }

    @Override
    protected Server createJaxRsServer() {
        JAXRSServerFactoryBean factoryBean = null;
        String[] beanNames = this.applicationContext.getBeanNamesForAnnotation(ApplicationPath.class);
        if (beanNames.length > 0) {
            Set<String> componentScanPackagesSet = AbstractSpringComponentScanServer.parseSetProperty(this.componentScanPackages);
            Set<String> componentScanBeansSet = AbstractSpringComponentScanServer.parseSetProperty(this.componentScanBeans);
            for (String beanName : beanNames) {
                if (!this.isComponentMatched(beanName, componentScanPackagesSet, componentScanBeansSet)) continue;
                Application app = (Application)this.applicationContext.getBean(beanName, Application.class);
                factoryBean = this.createFactoryBeanFromApplication(app);
                for (String cxfBeanName : this.applicationContext.getBeanNamesForAnnotation(Provider.class)) {
                    if (!this.isComponentMatched(cxfBeanName, componentScanPackagesSet, componentScanBeansSet)) continue;
                    this.addCxfProvider(this.getProviderBean(cxfBeanName));
                }
                break;
            }
        }
        if (!StringUtils.isEmpty((String)this.classesScanPackages)) {
            try {
                Map appClasses = ClasspathScanner.findClasses((String)this.classesScanPackages, (Class[])new Class[]{ApplicationPath.class});
                List apps = CastUtils.cast(JAXRSServerFactoryBeanDefinitionParser.createBeansFromDiscoveredClasses(this.applicationContext, (Collection)appClasses.get(ApplicationPath.class), null));
                if (!apps.isEmpty()) {
                    factoryBean = this.createFactoryBeanFromApplication((Application)apps.get(0));
                    Map cxfClasses = ClasspathScanner.findClasses((String)this.classesScanPackages, (Class[])new Class[]{Provider.class});
                    this.addCxfProvidersFromClasses((Collection)cxfClasses.get(Provider.class));
                }
            }
            catch (Exception ex) {
                throw new ServiceConstructionException((Throwable)ex);
            }
        }
        if (factoryBean != null) {
            this.setFactoryCxfProviders(factoryBean);
            return factoryBean.create();
        }
        return super.createJaxRsServer();
    }

    @Override
    protected void setJaxrsResources(JAXRSServerFactoryBean factory) {
        Set<String> componentScanPackagesSet = AbstractSpringComponentScanServer.parseSetProperty(this.componentScanPackages);
        Set<String> componentScanBeansSet = AbstractSpringComponentScanServer.parseSetProperty(this.componentScanBeans);
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            if (this.isValidComponent(beanName, Path.class, componentScanPackagesSet, componentScanBeansSet)) {
                SpringResourceFactory resourceFactory = new SpringResourceFactory(beanName);
                resourceFactory.setApplicationContext(this.applicationContext);
                this.resourceProviders.add(resourceFactory);
                continue;
            }
            if (this.isValidComponent(beanName, javax.ws.rs.ext.Provider.class, componentScanPackagesSet, componentScanBeansSet)) {
                this.jaxrsProviders.add(this.getProviderBean(beanName));
                continue;
            }
            if (!this.isValidComponent(beanName, Provider.class, componentScanPackagesSet, componentScanBeansSet)) continue;
            this.addCxfProvider(this.getProviderBean(beanName));
        }
        if (!StringUtils.isEmpty((String)this.classesScanPackages)) {
            try {
                Map classes = ClasspathScanner.findClasses((String)this.classesScanPackages, (Class[])new Class[]{javax.ws.rs.ext.Provider.class, Provider.class});
                this.jaxrsProviders.addAll(JAXRSServerFactoryBeanDefinitionParser.createBeansFromDiscoveredClasses(this.applicationContext, (Collection)classes.get(javax.ws.rs.ext.Provider.class), null));
                AbstractSpringComponentScanServer.warnIfDuplicatesAvailable(this.jaxrsProviders);
                this.addCxfProvidersFromClasses((Collection)classes.get(Provider.class));
            }
            catch (Exception ex) {
                throw new ServiceConstructionException((Throwable)ex);
            }
        }
        factory.setResourceProviders(this.getResourceProviders());
        factory.setProviders(this.getJaxrsProviders());
        this.setFactoryCxfProviders(factory);
    }

    protected void setFactoryCxfProviders(JAXRSServerFactoryBean factory) {
        factory.setFeatures(this.getFeatures());
        factory.setInInterceptors(this.getInInterceptors());
        factory.setOutInterceptors(this.getOutInterceptors());
        factory.setOutFaultInterceptors(this.getOutFaultInterceptors());
    }

    protected void addCxfProvidersFromClasses(Collection<Class<?>> classes) {
        List<Object> cxfProviders = JAXRSServerFactoryBeanDefinitionParser.createBeansFromDiscoveredClasses(this.applicationContext, classes, null);
        for (Object cxfProvider : cxfProviders) {
            this.addCxfProvider(cxfProvider);
        }
        AbstractSpringComponentScanServer.warnIfDuplicatesAvailable(this.cxfFeatures);
    }

    protected boolean isValidComponent(String beanName, Class<? extends Annotation> ann, Set<String> componentScanPackagesSet, Set<String> componentScanBeansSet) {
        return this.isAnnotationAvailable(beanName, ann) && this.nonProxyClass(beanName) && this.isComponentMatched(beanName, componentScanPackagesSet, componentScanBeansSet);
    }

    protected boolean isComponentMatched(String beanName, Set<String> componentScanPackagesSet, Set<String> componentScanBeansSet) {
        return this.matchesServiceAnnotation(beanName) && this.matchesComponentPackage(beanName, componentScanPackagesSet) && this.matchesComponentName(beanName, componentScanBeansSet);
    }

    protected boolean nonProxyClass(String beanName) {
        Class type = ClassHelper.getRealClassFromClass((Class)this.applicationContext.getType(beanName));
        if (Proxy.isProxyClass(type) && this.applicationContext.isSingleton(beanName)) {
            type = ClassHelper.getRealClass((Object)this.applicationContext.getBean(beanName));
        }
        if (Proxy.isProxyClass(type)) {
            LOG.fine("Can not determine the real class of the component '" + beanName + "'");
            return false;
        }
        return true;
    }

    protected boolean matchesComponentName(String beanName, Set<String> componentScanBeansSet) {
        return componentScanBeansSet == null || componentScanBeansSet.contains(beanName);
    }

    protected boolean matchesComponentPackage(String beanName, Set<String> componentScanPackagesSet) {
        return componentScanPackagesSet == null || !this.applicationContext.isSingleton(beanName) || componentScanPackagesSet.contains(PackageUtils.getPackageName(this.applicationContext.getBean(beanName).getClass()));
    }

    private static void warnIfDuplicatesAvailable(List<? extends Object> providers) {
        HashSet<String> classNames = new HashSet<String>();
        for (Object object : providers) {
            if (classNames.add(object.getClass().getName())) continue;
            LOG.warning("Duplicate Provider " + object.getClass().getName() + " has been detected");
        }
    }

    private Object getProviderBean(String beanName) {
        return this.applicationContext.getBean(beanName);
    }

    protected void addCxfProvider(Object bean) {
        Provider ann = bean.getClass().getAnnotation(Provider.class);
        if (ann.scope() == Provider.Scope.Client) {
            return;
        }
        if (ann.value() == Provider.Type.Feature) {
            this.cxfFeatures.add((Feature)bean);
        } else if (ann.value() == Provider.Type.InInterceptor) {
            super.getInInterceptors().add((Interceptor)bean);
        } else if (ann.value() == Provider.Type.OutInterceptor) {
            super.getOutInterceptors().add((Interceptor)bean);
        } else if (ann.value() == Provider.Type.OutFaultInterceptor) {
            super.getOutFaultInterceptors().add((Interceptor)bean);
        }
    }

    protected boolean matchesServiceAnnotation(String beanName) {
        return this.serviceAnnotation == null || this.isAnnotationAvailable(beanName, this.serviceAnnotation);
    }

    protected <A extends Annotation> boolean isAnnotationAvailable(String beanName, Class<A> annClass) {
        return this.applicationContext.findAnnotationOnBean(beanName, annClass) != null;
    }

    protected List<ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    protected List<Object> getJaxrsProviders() {
        return this.jaxrsProviders;
    }

    @Override
    public List<Feature> getFeatures() {
        return this.cxfFeatures;
    }

    protected JAXRSServerFactoryBean createFactoryBeanFromApplication(Application app) {
        return ResourceUtils.createApplication(app, false, true, false, this.getBus());
    }

    protected static Set<String> parseSetProperty(String componentScanProp) {
        return !StringUtils.isEmpty((String)componentScanProp) ? ClasspathScanner.parsePackages((String)componentScanProp) : null;
    }
}

