/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDListModel
extends Model<SerializableList<SDSet>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private ReviewMgr reviewMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)SDListModel.class.getName());
    private SDSet sdSet;
    private SerializableList<SDSet> sdSets = null;

    public SDListModel(boolean isStatic, Session session) {
        Injector.get().inject((Object)this);
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.reviewMgr.setAdmin(session);
        }
    }

    public SDListModel(SDSet sdSet, Session session) {
        Injector.get().inject((Object)this);
        this.sdSet = sdSet;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.reviewMgr.setAdmin(session);
        }
    }

    public SerializableList<SDSet> getObject() {
        if (this.sdSets != null) {
            LOG.debug(".getObject count: " + this.sdSets.size());
            return this.sdSets;
        }
        if (this.sdSet == null) {
            LOG.debug(".getObject null");
            this.sdSets = new SerializableList(new ArrayList());
        } else {
            LOG.debug(".getObject sdSetNm: " + this.sdSet.getName());
            this.sdSets = new SerializableList(this.getList(this.sdSet));
        }
        return this.sdSets;
    }

    public void setObject(SerializableList<SDSet> object) {
        LOG.debug(".setObject count: " + object.size());
        this.sdSets = object;
    }

    public void detach() {
        this.sdSets = null;
        this.sdSet = null;
    }

    private List<SDSet> getList(SDSet sdSet) {
        List sdSetList = null;
        if (sdSet == null) {
            throw new RuntimeException("Invalid SDSet State");
        }
        try {
            String szSdSetNm = sdSet.getName();
            LOG.debug(".getList sdSetNm: " + szSdSetNm);
            if (CollectionUtils.isNotEmpty((Collection)sdSet.getMembers())) {
                Object[] roleNms = sdSet.getMembers().toArray();
                String szRoleNm = (String)roleNms[0];
                Role role = new Role(szRoleNm);
                sdSetList = sdSet.getType().equals((Object)SDSet.SDType.STATIC) ? this.reviewMgr.ssdRoleSets(role) : this.reviewMgr.dsdRoleSets(role);
            } else {
                sdSetList = sdSet.getType().equals((Object)SDSet.SDType.STATIC) ? this.reviewMgr.ssdSets(sdSet) : this.reviewMgr.dsdSets(sdSet);
            }
            if (CollectionUtils.isNotEmpty((Collection)sdSetList)) {
                Collections.sort(sdSetList, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return sdSetList;
    }
}

