/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.googlecode.wicket.kendo.ui.form.datetime.DatePicker;
import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.directory.fortress.core.model.Bind;
import org.apache.directory.fortress.core.model.UserAudit;
import org.apache.directory.fortress.core.util.time.TUtil;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.modal.ModalWindow;
import org.apache.directory.fortress.web.model.AuditBindListModel;
import org.apache.directory.fortress.web.panel.AuditBindListPanel;
import org.apache.directory.fortress.web.panel.AuditUtils;
import org.apache.directory.fortress.web.panel.UserSearchModalPanel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditBindListPanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)AuditBindListPanel.class.getName());
    private Form listForm;
    private DefaultMutableTreeNode node;
    private TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid;
    private DefaultMutableTreeNode rootNode;
    private TextField userFld;
    protected DatePicker beginDateDP;
    protected DatePicker endDateDP;

    public AuditBindListPanel(String id, UserAudit userAudit) {
        super(id);
        this.init(userAudit);
    }

    private void init(UserAudit userAudit) {
        AuditBindListModel pageModel = new AuditBindListModel(userAudit, SecUtils.getSession((Component)this));
        this.setDefaultModel((IModel)pageModel);
        this.createAndLoadGrid();
        this.listForm = new Form("bindform");
        this.listForm.addOrReplace(new Component[]{this.grid});
        this.listForm.setModel((IModel)new CompoundPropertyModel((Object)userAudit));
        this.addEditFields();
        this.addButtons();
        this.add(new Component[]{this.listForm});
    }

    private void addEditFields() {
        this.userFld = new TextField("userId");
        this.userFld.setOutputMarkupId(true);
        1 ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.userFld.add(new Behavior[]{ajaxUpdater});
        this.listForm.add(new Component[]{this.userFld});
        this.addUserSearchModal();
        CheckBox failedOnlyCB = new CheckBox("failedOnly");
        failedOnlyCB.setOutputMarkupId(true);
        ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        failedOnlyCB.add(new Behavior[]{ajaxUpdater});
        failedOnlyCB.setRequired(false);
        this.listForm.add(new Component[]{failedOnlyCB});
        this.beginDateDP = new DatePicker("beginDate");
        this.beginDateDP.setOutputMarkupId(true);
        ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.beginDateDP.add(new Behavior[]{ajaxUpdater});
        this.beginDateDP.setRequired(false);
        this.listForm.add(new Component[]{this.beginDateDP});
        this.endDateDP = new DatePicker("endDate");
        this.endDateDP.setOutputMarkupId(true);
        ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.endDateDP.add(new Behavior[]{ajaxUpdater});
        this.endDateDP.setRequired(false);
        this.listForm.add(new Component[]{this.endDateDP});
    }

    private void addButtons() {
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void createAndLoadGrid() {
        ArrayList<PropertyColumn> columns = new ArrayList<PropertyColumn>();
        PropertyColumn reqStart = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Timestamp")), "userObject.reqStart");
        reqStart.setInitialSize(200);
        columns.add(reqStart);
        PropertyColumn requAuthzId = new PropertyColumn((IModel)Model.of((Serializable)((Object)"User ID")), "userObject.reqDN");
        requAuthzId.setInitialSize(200);
        columns.add(requAuthzId);
        PropertyColumn reqResult = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Result")), "userObject.reqResult");
        reqResult.setInitialSize(80);
        columns.add(reqResult);
        List binds = (List)this.getDefaultModel().getObject();
        DefaultTreeModel treeModel = this.createTreeModel(binds);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        this.grid.setAllowSelectMultiple(false);
        this.grid.setClickRowToSelect(true);
        this.grid.setClickRowToDeselect(false);
        this.grid.setSelectToEdit(false);
        this.grid.getTreeState().expandAll();
        this.grid.setOutputMarkupId(true);
    }

    private void addUserSearchModal() {
        Component[] componentArray = new Component[1];
        ModalWindow usersModalWindow = new ModalWindow("usersearchmodal");
        componentArray[0] = usersModalWindow;
        this.listForm.add(componentArray);
        UserSearchModalPanel userSearchModalPanel = new UserSearchModalPanel(usersModalWindow.getContentId(), usersModalWindow);
        usersModalWindow.setContent((Component)userSearchModalPanel);
        usersModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        usersModalWindow.setTitle("User Search Modal");
        usersModalWindow.setInitialWidth(1000);
        usersModalWindow.setInitialHeight(700);
        usersModalWindow.setCookieName("user-search-modal");
    }

    private DefaultTreeModel createTreeModel(List<Bind> binds) {
        this.rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        if (binds == null) {
            LOG.debug("no Authentications found");
        } else {
            LOG.debug("Binds found:" + binds.size());
            this.info((Serializable)((Object)("Loading " + binds.size() + " objects into list panel")));
            this.loadTree(binds);
        }
        return model;
    }

    private void loadTree(List<Bind> binds) {
        for (Bind bind : binds) {
            Date start = null;
            try {
                start = TUtil.decodeGeneralizedTime((String)bind.getReqStart());
            }
            catch (ParseException pe) {
                LOG.warn("ParseException=" + pe.getMessage());
            }
            if (start != null) {
                SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                String formattedDate = formatter.format(start);
                bind.setReqStart(formattedDate);
            }
            if (bind.getReqResult().equals("0")) {
                bind.setReqResult("SUCCESS");
            } else {
                bind.setReqResult("FAILURE");
            }
            bind.setReqDN(AuditUtils.getAuthZId((String)bind.getReqDN()));
            this.rootNode.add(new DefaultMutableTreeNode(bind));
        }
    }
}

