/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import org.apache.felix.webconsole.internal.servlet.AbstractPluginAdapter;
import org.osgi.framework.ServiceReference;

public class SimplePluginAdapter
extends AbstractPluginAdapter {
    private static final long serialVersionUID = 1L;
    private final Servlet plugin;
    private final String resStart;

    public SimplePluginAdapter(Servlet plugin, ServiceReference<Servlet> serviceReference, String label, String title, String[] cssReferences) {
        super(serviceReference.getBundle().getBundleContext(), label, title, cssReferences);
        this.plugin = plugin;
        String prefix = "/".concat(label);
        this.resStart = prefix.concat("/res/");
        this.activate(serviceReference.getBundle().getBundleContext());
    }

    @Override
    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.plugin.service((ServletRequest)req, (ServletResponse)res);
    }

    @Override
    protected URL getResource(String path) {
        if (path != null && path.startsWith(this.resStart)) {
            return this.plugin.getClass().getResource(path.substring(this.label.length() + 1));
        }
        return null;
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            super.init(config);
            this.plugin.init(config);
        }
        catch (ServletException se) {
            this.deactivate();
            throw se;
        }
    }

    @Override
    protected boolean isHtmlRequest(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        if (requestUri.endsWith(".html")) {
            return true;
        }
        int lastSlash = requestUri.lastIndexOf(47);
        int lastDot = requestUri.indexOf(46, lastSlash + 1);
        return lastDot < 0;
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        if (req instanceof HttpServletRequest && ((HttpServletRequest)req).getMethod().equals("GET")) {
            super.service(req, resp);
        } else {
            this.plugin.service(req, resp);
        }
    }

    public void destroy() {
        try {
            this.plugin.destroy();
            super.destroy();
        }
        finally {
            this.deactivate();
        }
    }
}

