/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;

public class PreReceiveHookChain
implements PreReceiveHook {
    private final PreReceiveHook[] hooks;
    private final int count;

    public static PreReceiveHook newChain(List<? extends PreReceiveHook> hooks) {
        PreReceiveHook[] newHooks = new PreReceiveHook[hooks.size()];
        int i2 = 0;
        for (PreReceiveHook preReceiveHook : hooks) {
            if (preReceiveHook == PreReceiveHook.NULL) continue;
            newHooks[i2++] = preReceiveHook;
        }
        switch (i2) {
            case 0: {
                return PreReceiveHook.NULL;
            }
            case 1: {
                return newHooks[0];
            }
        }
        return new PreReceiveHookChain(newHooks, i2);
    }

    @Override
    public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
        int i2 = 0;
        while (i2 < this.count) {
            this.hooks[i2].onPreReceive(rp, commands);
            ++i2;
        }
    }

    private PreReceiveHookChain(PreReceiveHook[] hooks, int count) {
        this.hooks = hooks;
        this.count = count;
    }
}

