/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins;

import grails.artefact.Enhanced;
import grails.core.ArtefactHandler;
import grails.core.GrailsApplication;
import grails.plugins.GrailsPluginManager;
import grails.plugins.GrailsVersionUtils;
import grails.plugins.Plugin;
import grails.plugins.PluginFilter;
import grails.plugins.exceptions.PluginException;
import grails.plugins.metadata.GrailsPlugin;
import grails.util.Environment;
import grails.util.GrailsNameUtils;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.config.NavigableMap;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.plugins.support.WatchPattern;
import org.grails.spring.RuntimeSpringConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractGrailsPluginManager
implements GrailsPluginManager {
    private static final Log LOG = LogFactory.getLog(AbstractGrailsPluginManager.class);
    private static final String BLANK = "";
    public static final String CONFIG_FILE = "application.groovy";
    protected List<grails.plugins.GrailsPlugin> pluginList = new ArrayList<grails.plugins.GrailsPlugin>();
    protected GrailsApplication application;
    protected Resource[] pluginResources = new Resource[0];
    protected Map<String, grails.plugins.GrailsPlugin> plugins = new HashMap<String, grails.plugins.GrailsPlugin>();
    protected Map<String, grails.plugins.GrailsPlugin> classNameToPluginMap = new HashMap<String, grails.plugins.GrailsPlugin>();
    protected Class<?>[] pluginClasses = new Class[0];
    protected boolean initialised = false;
    protected boolean shutdown = false;
    protected ApplicationContext applicationContext;
    protected Map<String, grails.plugins.GrailsPlugin> failedPlugins = new HashMap<String, grails.plugins.GrailsPlugin>();
    protected boolean loadCorePlugins = true;
    private static final String CONFIG_BINDING_USER_HOME = "userHome";
    private static final String CONFIG_BINDING_APP_NAME = "appName";
    private static final String CONFIG_BINDING_APP_VERSION = "appVersion";

    public AbstractGrailsPluginManager(GrailsApplication application2) {
        Assert.notNull((Object)application2, "Argument [application] cannot be null!");
        this.application = application2;
    }

    @Override
    public List<TypeFilter> getTypeFilters() {
        ArrayList<? extends TypeFilter> list = new ArrayList<TypeFilter>();
        for (grails.plugins.GrailsPlugin grailsPlugin : this.pluginList) {
            list.addAll(grailsPlugin.getTypeFilters());
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public grails.plugins.GrailsPlugin[] getAllPlugins() {
        return this.pluginList.toArray(new grails.plugins.GrailsPlugin[this.pluginList.size()]);
    }

    @Override
    public grails.plugins.GrailsPlugin[] getFailedLoadPlugins() {
        return this.failedPlugins.values().toArray(new grails.plugins.GrailsPlugin[this.failedPlugins.size()]);
    }

    @Override
    public boolean isInitialised() {
        return this.initialised;
    }

    protected void checkInitialised() {
        Assert.state(this.initialised, "Must call loadPlugins() before invoking configurational methods on GrailsPluginManager");
    }

    @Override
    public grails.plugins.GrailsPlugin getFailedPlugin(String name) {
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName(name);
        }
        return this.failedPlugins.get(name);
    }

    @Override
    public void doRuntimeConfiguration(RuntimeSpringConfiguration springConfig) {
        ApplicationContext context = springConfig.getUnrefreshedApplicationContext();
        AutowireCapableBeanFactory autowireCapableBeanFactory = context.getAutowireCapableBeanFactory();
        if (autowireCapableBeanFactory instanceof ConfigurableListableBeanFactory) {
            ConverterRegistry converterRegistry;
            ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)autowireCapableBeanFactory;
            ConversionService existingConversionService = beanFactory.getConversionService();
            if (existingConversionService == null) {
                GenericConversionService conversionService = new GenericConversionService();
                converterRegistry = conversionService;
                beanFactory.setConversionService(conversionService);
            } else {
                converterRegistry = (ConverterRegistry)((Object)existingConversionService);
            }
            converterRegistry.addConverter(new Converter<NavigableMap.NullSafeNavigator, Object>(){

                @Override
                public Object convert(NavigableMap.NullSafeNavigator source) {
                    return null;
                }
            });
        }
        this.checkInitialised();
        for (grails.plugins.GrailsPlugin plugin2 : this.pluginList) {
            if (!plugin2.supportsCurrentScopeAndEnvironment() || !plugin2.isEnabled(context.getEnvironment().getActiveProfiles())) continue;
            plugin2.doWithRuntimeConfiguration(springConfig);
        }
    }

    @Override
    public void doRuntimeConfiguration(String pluginName, RuntimeSpringConfiguration springConfig) {
        String[] loadAfters;
        this.checkInitialised();
        grails.plugins.GrailsPlugin plugin2 = this.getGrailsPlugin(pluginName);
        if (plugin2 == null) {
            throw new PluginException("Plugin [" + pluginName + "] not found");
        }
        if (!plugin2.supportsCurrentScopeAndEnvironment()) {
            return;
        }
        if (!plugin2.isEnabled(this.applicationContext.getEnvironment().getActiveProfiles())) {
            return;
        }
        String[] dependencyNames = plugin2.getDependencyNames();
        this.doRuntimeConfigurationForDependencies(dependencyNames, springConfig);
        for (String name : loadAfters = plugin2.getLoadAfterNames()) {
            grails.plugins.GrailsPlugin current = this.getGrailsPlugin(name);
            if (current == null) continue;
            current.doWithRuntimeConfiguration(springConfig);
        }
        plugin2.doWithRuntimeConfiguration(springConfig);
    }

    private void doRuntimeConfigurationForDependencies(String[] dependencyNames, RuntimeSpringConfiguration springConfig) {
        for (String dn : dependencyNames) {
            grails.plugins.GrailsPlugin current = this.getGrailsPlugin(dn);
            if (current == null) {
                throw new PluginException("Cannot load Plugin. Dependency [" + String.valueOf(current) + "] not found");
            }
            String[] pluginDependencies = current.getDependencyNames();
            if (pluginDependencies.length > 0) {
                this.doRuntimeConfigurationForDependencies(pluginDependencies, springConfig);
            }
            if (this.isPluginDisabledForProfile(current)) continue;
            current.doWithRuntimeConfiguration(springConfig);
        }
    }

    @Override
    public void doPostProcessing(ApplicationContext ctx) {
        this.checkInitialised();
        for (grails.plugins.GrailsPlugin plugin2 : this.pluginList) {
            if (this.isPluginDisabledForProfile(plugin2) || !plugin2.supportsCurrentScopeAndEnvironment()) continue;
            plugin2.doWithApplicationContext(ctx);
        }
    }

    public Resource[] getPluginResources() {
        return this.pluginResources;
    }

    @Override
    public grails.plugins.GrailsPlugin getGrailsPlugin(String name) {
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName(name);
        }
        return this.plugins.get(name);
    }

    @Override
    public grails.plugins.GrailsPlugin getGrailsPluginForClassName(String name) {
        return this.classNameToPluginMap.get(name);
    }

    @Override
    public grails.plugins.GrailsPlugin getGrailsPlugin(String name, Object version) {
        grails.plugins.GrailsPlugin plugin2;
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName(name);
        }
        if ((plugin2 = this.plugins.get(name)) != null && GrailsVersionUtils.isValidVersion(plugin2.getVersion(), version.toString())) {
            return plugin2;
        }
        return null;
    }

    @Override
    public boolean hasGrailsPlugin(String name) {
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName(name);
        }
        return this.plugins.containsKey(name);
    }

    @Override
    public void doDynamicMethods() {
        this.checkInitialised();
        Class[] allClasses = this.application.getAllClasses();
        if (allClasses != null) {
            for (Class c : allClasses) {
                ExpandoMetaClass emc = new ExpandoMetaClass(c, true, true);
                emc.initialize();
            }
            ApplicationContext ctx = this.applicationContext;
            for (grails.plugins.GrailsPlugin plugin2 : this.pluginList) {
                if (!plugin2.isEnabled(ctx.getEnvironment().getActiveProfiles())) continue;
                plugin2.doWithDynamicMethods(ctx);
            }
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext != null) {
            for (grails.plugins.GrailsPlugin plugin2 : this.pluginList) {
                plugin2.setApplicationContext(applicationContext);
            }
        }
    }

    @Override
    public void setApplication(GrailsApplication application2) {
        Assert.notNull((Object)application2, "Argument [application] cannot be null");
        this.application = application2;
        for (grails.plugins.GrailsPlugin plugin2 : this.pluginList) {
            plugin2.setApplication(application2);
        }
    }

    @Override
    public void registerProvidedArtefacts(GrailsApplication app) {
        this.checkInitialised();
        ArrayList<grails.plugins.GrailsPlugin> plugins = new ArrayList<grails.plugins.GrailsPlugin>(this.pluginList);
        Collections.reverse(plugins);
        for (grails.plugins.GrailsPlugin plugin2 : plugins) {
            if (!plugin2.supportsCurrentScopeAndEnvironment() || this.isPluginDisabledForProfile(plugin2)) continue;
            for (Class<?> artefact : plugin2.getProvidedArtefacts()) {
                String shortName = GrailsNameUtils.getShortName(artefact);
                if (artefact.getName().equals(shortName)) {
                    LOG.warn("Plugin " + plugin2.getName() + " has an artefact " + shortName + " without a package name This could lead to artefacts being excluded from the application");
                    if (app.getClassForName(shortName) != null) {
                        LOG.error("Plugin " + plugin2.getName() + " has an artefact " + shortName + " that is being excluded from the application because another artefact exists with the same name without a package defined.");
                    }
                }
                if (this.isAlreadyRegistered(app, artefact)) continue;
                app.addOverridableArtefact(artefact);
            }
        }
    }

    private boolean isAlreadyRegistered(GrailsApplication app, Class<?> artefact) {
        return app.getClassForName(artefact.getName()) != null;
    }

    @Override
    public void doArtefactConfiguration() {
        this.checkInitialised();
        for (grails.plugins.GrailsPlugin plugin2 : this.pluginList) {
            if (this.isPluginDisabledForProfile(plugin2) || !plugin2.supportsCurrentScopeAndEnvironment()) continue;
            plugin2.doArtefactConfiguration();
        }
    }

    protected boolean isPluginDisabledForProfile(grails.plugins.GrailsPlugin plugin2) {
        return this.applicationContext != null && !plugin2.isEnabled(this.applicationContext.getEnvironment().getActiveProfiles());
    }

    @Override
    public void onStartup(Map<String, Object> event) {
        for (grails.plugins.GrailsPlugin plugin2 : this.pluginList) {
            if (!(plugin2.getInstance() instanceof Plugin)) continue;
            ((Plugin)plugin2.getInstance()).onStartup(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.checkInitialised();
        try {
            ArrayList<grails.plugins.GrailsPlugin> reversePluginList = new ArrayList<grails.plugins.GrailsPlugin>(this.pluginList);
            Collections.reverse(reversePluginList);
            for (grails.plugins.GrailsPlugin plugin2 : reversePluginList) {
                if (!plugin2.isEnabled(this.applicationContext.getEnvironment().getActiveProfiles()) || !plugin2.supportsCurrentScopeAndEnvironment()) continue;
                plugin2.notifyOfEvent(2, plugin2);
            }
        }
        finally {
            this.shutdown = true;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public void setPluginFilter(PluginFilter pluginFilter) {
    }

    @Override
    public void setLoadCorePlugins(boolean shouldLoadCorePlugins) {
        this.loadCorePlugins = shouldLoadCorePlugins;
    }

    @Override
    public void informOfClassChange(Class<?> aClass) {
        if (aClass == null || this.application == null) {
            return;
        }
        ArtefactHandler handler = this.application.getArtefactType(aClass);
        if (handler == null) {
            return;
        }
        String pluginName = handler.getPluginName();
        if (pluginName == null) {
            return;
        }
        grails.plugins.GrailsPlugin plugin2 = this.getGrailsPlugin(pluginName);
        if (plugin2 != null) {
            if (!plugin2.isEnabled(this.applicationContext.getEnvironment().getActiveProfiles())) {
                return;
            }
            plugin2.notifyOfEvent(0, aClass);
        } else {
            String classNameAsPath = aClass.getName().replace('.', File.separatorChar);
            String groovyClass = classNameAsPath + ".groovy";
            String javaClass = classNameAsPath + ".java";
            for (grails.plugins.GrailsPlugin grailsPlugin : this.pluginList) {
                List<WatchPattern> watchPatterns = grailsPlugin.getWatchedResourcePatterns();
                if (watchPatterns == null) continue;
                for (WatchPattern watchPattern : watchPatterns) {
                    File parent = watchPattern.getDirectory();
                    String extension = watchPattern.getExtension();
                    if (parent == null || extension == null) continue;
                    File f = new File(parent, groovyClass);
                    if (f.exists() && f.getName().endsWith(extension)) {
                        grailsPlugin.notifyOfEvent(0, aClass);
                        continue;
                    }
                    f = new File(parent, javaClass);
                    if (!f.exists() || !f.getName().endsWith(extension)) continue;
                    grailsPlugin.notifyOfEvent(0, aClass);
                }
            }
        }
    }

    @Override
    public String getPluginPath(String name) {
        return this.getPluginPath(name, false);
    }

    @Override
    public String getPluginPath(String name, boolean forceCamelCase) {
        grails.plugins.GrailsPlugin plugin2 = this.getGrailsPlugin(name);
        if (plugin2 != null && !plugin2.isBasePlugin()) {
            if (forceCamelCase) {
                return plugin2.getPluginPathCamelCase();
            }
            return plugin2.getPluginPath();
        }
        return BLANK;
    }

    @Override
    public String getPluginPathForInstance(Object instance) {
        if (instance != null) {
            return this.getPluginPathForClass(instance.getClass());
        }
        return null;
    }

    @Override
    public grails.plugins.GrailsPlugin getPluginForInstance(Object instance) {
        if (instance != null) {
            return this.getPluginForClass(instance.getClass());
        }
        return null;
    }

    @Override
    public grails.plugins.GrailsPlugin getPluginForClass(Class<?> theClass) {
        GrailsPlugin ann;
        if (theClass != null && (ann = theClass.getAnnotation(GrailsPlugin.class)) != null) {
            return this.getGrailsPlugin(ann.name());
        }
        return null;
    }

    @Override
    public void informPluginsOfConfigChange() {
        for (grails.plugins.GrailsPlugin plugin2 : this.pluginList) {
            plugin2.notifyOfEvent(1, this.application.getConfig());
        }
    }

    @Override
    public void informOfFileChange(File file) {
        String className = GrailsResourceUtils.getClassName(file.getAbsolutePath());
        Class<?> cls = null;
        if (className != null) {
            cls = this.loadApplicationClass(className);
        }
        this.informOfClassChange(file, cls);
    }

    static ConfigSlurper getConfigSlurper(GrailsApplication application2) {
        String environment2 = Environment.getCurrent().getName();
        ConfigSlurper configSlurper = new ConfigSlurper(environment2);
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put(CONFIG_BINDING_USER_HOME, System.getProperty("user.home"));
        if (application2 != null) {
            binding.put(CONFIG_BINDING_APP_NAME, application2.getMetadata().getApplicationName());
            binding.put(CONFIG_BINDING_APP_VERSION, application2.getMetadata().getApplicationVersion());
            binding.put("grailsApplication", application2);
        }
        configSlurper.setBinding(binding);
        return configSlurper;
    }

    @Override
    public void informOfClassChange(File file, Class cls) {
        if (file.getName().equals(CONFIG_FILE)) {
            ConfigSlurper configSlurper = AbstractGrailsPluginManager.getConfigSlurper(this.application);
            try {
                ConfigObject c = configSlurper.parse(file.toURI().toURL());
                this.application.getConfig().merge(c);
                Map flat = c.flatten();
                this.application.getConfig().merge(flat);
                this.application.configChanged();
                this.informPluginsOfConfigChange();
            }
            catch (Exception e) {
                LOG.debug("Error in changing Config", e);
            }
        } else {
            if (cls != null) {
                Class[] mixinClasses;
                MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
                registry.removeMetaClass(cls);
                ExpandoMetaClass newMc = new ExpandoMetaClass(cls, true, true);
                newMc.initialize();
                registry.setMetaClass(cls, newMc);
                Enhanced en = AnnotationUtils.findAnnotation(cls, Enhanced.class);
                if (en != null && (mixinClasses = en.mixins()) != null) {
                    DefaultGroovyMethods.mixin((MetaClass)newMc, mixinClasses);
                }
            }
            for (grails.plugins.GrailsPlugin grailsPlugin : this.pluginList) {
                if (!grailsPlugin.hasInterestInChange(file.getAbsolutePath())) continue;
                try {
                    if (cls == null) {
                        grailsPlugin.notifyOfEvent(0, new FileSystemResource(file));
                    } else {
                        grailsPlugin.notifyOfEvent(0, cls);
                    }
                    Environment.setCurrentReloadError(null);
                }
                catch (Exception e) {
                    LOG.error("Plugin " + String.valueOf(grailsPlugin) + " could not reload changes to file [" + String.valueOf(file) + "]: " + e.getMessage(), e);
                    Environment.setCurrentReloadError(e);
                }
            }
        }
    }

    private Class<?> loadApplicationClass(String className) {
        Class<?> cls = null;
        try {
            cls = this.application.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cls;
    }

    public String getPluginPathForClass(Class<?> theClass) {
        GrailsPlugin ann;
        if (theClass != null && (ann = theClass.getAnnotation(GrailsPlugin.class)) != null) {
            return this.getPluginPath(ann.name());
        }
        return null;
    }

    @Override
    public String getPluginViewsPathForInstance(Object instance) {
        if (instance != null) {
            return this.getPluginViewsPathForClass(instance.getClass());
        }
        return null;
    }

    public String getPluginViewsPathForClass(Class<?> theClass) {
        String path;
        if (theClass != null && StringUtils.hasText(path = this.getPluginPathForClass(theClass))) {
            return path + "/grails-app/views";
        }
        return null;
    }
}

