/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import java.util.Collections;
import java.util.Map;

@Internal
final class SimpleClassElement
implements ClassElement {
    private final String typeName;
    private final boolean isInterface;
    private final AnnotationMetadata annotationMetadata;
    private final Map<String, ClassElement> typeArguments;

    SimpleClassElement(String typeName) {
        this(typeName, false, AnnotationMetadata.EMPTY_METADATA);
    }

    SimpleClassElement(String typeName, boolean isInterface, AnnotationMetadata annotationMetadata) {
        this(typeName, isInterface, annotationMetadata, Collections.emptyMap());
    }

    SimpleClassElement(String typeName, boolean isInterface, AnnotationMetadata annotationMetadata, Map<String, ClassElement> typeArguments) {
        this.typeName = typeName;
        this.isInterface = isInterface;
        this.annotationMetadata = annotationMetadata != null ? annotationMetadata : AnnotationMetadata.EMPTY_METADATA;
        this.typeArguments = typeArguments;
    }

    @Override
    @NonNull
    public Map<String, ClassElement> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    @NonNull
    public Map<String, ClassElement> getTypeArguments(@NonNull String type) {
        if (this.typeName.equals(type)) {
            return this.typeArguments;
        }
        return ClassElement.super.getTypeArguments(type);
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public boolean isAssignable(String type) {
        return this.typeName.equals(type);
    }

    @Override
    public boolean isAssignable(ClassElement type) {
        return false;
    }

    @Override
    public ClassElement toArray() {
        throw new UnsupportedOperationException("Cannot convert class elements produced by name to an array");
    }

    @Override
    public ClassElement fromArray() {
        throw new UnsupportedOperationException("Cannot convert class elements produced by from an array");
    }

    @Override
    @NonNull
    public String getName() {
        return this.typeName;
    }

    @Override
    public boolean isPackagePrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    @NonNull
    public Object getNativeType() {
        return this.typeName;
    }
}

