/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.gradle;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.OrderUtil;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.gradle.GradleBuild;
import org.grails.forge.build.gradle.GradleDependency;
import org.grails.forge.build.gradle.GradleDsl;
import org.grails.forge.build.gradle.GradlePlugin;
import org.grails.forge.options.BuildTool;

@Singleton
public class GradleBuildCreator {
    @NonNull
    public GradleBuild create(@NonNull GeneratorContext generatorContext) {
        GradleDsl gradleDsl = BuildTool.DEFAULT_OPTION.getGradleDsl().orElseThrow(() -> new IllegalArgumentException("GradleBuildCreator can only create Gradle builds"));
        List<GradlePlugin> gradlePlugins = generatorContext.getBuildPlugins().stream().filter(GradlePlugin.class::isInstance).map(GradlePlugin.class::cast).sorted(OrderUtil.COMPARATOR).collect(Collectors.toList());
        List<Object> buildRepositories = generatorContext.getBuildRepositories().stream().sorted(OrderUtil.COMPARATOR).toList();
        List<Object> repositories = generatorContext.getRepositories().stream().sorted(OrderUtil.COMPARATOR).toList();
        return new GradleBuild(gradleDsl, this.resolveDependencies(generatorContext), this.resolveBuildscriptDependencies(generatorContext), gradlePlugins, buildRepositories, repositories);
    }

    @NonNull
    private List<GradleDependency> resolveDependencies(@NonNull GeneratorContext generatorContext) {
        return generatorContext.getDependencies().stream().map(dep -> new GradleDependency((Dependency)dep, generatorContext)).sorted(GradleDependency.COMPARATOR).collect(Collectors.toList());
    }

    @NonNull
    private List<GradleDependency> resolveBuildscriptDependencies(@NonNull GeneratorContext generatorContext) {
        return generatorContext.getBuildscriptDependencies().stream().map(dep -> new GradleDependency((Dependency)dep, generatorContext)).sorted(GradleDependency.COMPARATOR).collect(Collectors.toList());
    }
}

