/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteSource;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.CharSource;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.FileWriteMode;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Internal
public final class ZipFiles {
    private ZipFiles() {
    }

    static @UnknownKeyFor @NonNull @Initialized ByteSource asByteSource(@UnknownKeyFor @NonNull @Initialized ZipFile file, @UnknownKeyFor @NonNull @Initialized ZipEntry entry) {
        return new ZipEntryByteSource(file, entry);
    }

    static @UnknownKeyFor @NonNull @Initialized CharSource asCharSource(@UnknownKeyFor @NonNull @Initialized ZipFile file, @UnknownKeyFor @NonNull @Initialized ZipEntry entry, @UnknownKeyFor @NonNull @Initialized Charset charset) {
        return ZipFiles.asByteSource(file, entry).asCharSource(charset);
    }

    static @UnknownKeyFor @NonNull @Initialized FluentIterable<@UnknownKeyFor @NonNull @Initialized ZipEntry> entries(final @UnknownKeyFor @NonNull @Initialized ZipFile file) {
        Preconditions.checkNotNull((Object)file);
        return new FluentIterable<ZipEntry>(){

            public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ZipEntry> iterator() {
                return Iterators.forEnumeration(file.entries());
            }
        };
    }

    static void unzipFile(@UnknownKeyFor @NonNull @Initialized File zipFile, @UnknownKeyFor @NonNull @Initialized File targetDirectory) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)zipFile);
        Preconditions.checkNotNull((Object)targetDirectory);
        Preconditions.checkArgument((boolean)targetDirectory.isDirectory(), (String)"%s is not a valid directory", (Object)targetDirectory.getAbsolutePath());
        try (ZipFile zipFileObj = new ZipFile(zipFile);){
            for (ZipEntry entry : ZipFiles.entries(zipFileObj)) {
                ZipFiles.checkName(entry.getName());
                File targetFile = new File(targetDirectory, entry.getName());
                if (entry.isDirectory()) {
                    if (targetFile.isDirectory() || targetFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory: " + targetFile.getAbsolutePath());
                }
                File parentFile = targetFile.getParentFile();
                if (!parentFile.isDirectory() && !parentFile.mkdirs()) {
                    throw new IOException("Failed to create directory: " + parentFile.getAbsolutePath());
                }
                ZipFiles.asByteSource(zipFileObj, entry).copyTo(Files.asByteSink((File)targetFile, (FileWriteMode[])new FileWriteMode[0]));
            }
        }
    }

    private static void checkName(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (name.contains("..")) {
            for (File file = new File(name); file != null; file = file.getParentFile()) {
                if (!"..".equals(file.getName())) continue;
                throw new IOException("Cannot unzip file containing an entry with \"..\" in the name: " + name);
            }
        }
    }

    public static void zipDirectory(@UnknownKeyFor @NonNull @Initialized File sourceDirectory, @UnknownKeyFor @NonNull @Initialized File zipFile) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ZipFiles.zipDirectory(sourceDirectory, zipFile, false);
    }

    public static void zipDirectoryOverwrite(@UnknownKeyFor @NonNull @Initialized File sourceDirectory, @UnknownKeyFor @NonNull @Initialized File zipFile) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ZipFiles.zipDirectory(sourceDirectory, zipFile, true);
    }

    private static void zipDirectory(@UnknownKeyFor @NonNull @Initialized File sourceDirectory, @UnknownKeyFor @NonNull @Initialized File zipFile, @UnknownKeyFor @NonNull @Initialized boolean allowOverwrite) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)sourceDirectory);
        Preconditions.checkNotNull((Object)zipFile);
        Preconditions.checkArgument((boolean)sourceDirectory.isDirectory(), (String)"%s is not a valid directory", (Object)sourceDirectory.getAbsolutePath());
        if (!allowOverwrite) {
            Preconditions.checkArgument((!zipFile.exists() ? 1 : 0) != 0, (String)"%s already exists, file is not being overwritten", (Object)zipFile.getAbsolutePath());
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(zipFile));){
            ZipFiles.zipDirectory(sourceDirectory, outputStream);
        }
    }

    public static void zipDirectory(@UnknownKeyFor @NonNull @Initialized File sourceDirectory, @UnknownKeyFor @NonNull @Initialized OutputStream outputStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)sourceDirectory);
        Preconditions.checkNotNull((Object)outputStream);
        Preconditions.checkArgument((boolean)sourceDirectory.isDirectory(), (String)"%s is not a valid directory", (Object)sourceDirectory.getAbsolutePath());
        try (ZipOutputStream zos = new ZipOutputStream(outputStream);){
            for (File file : sourceDirectory.listFiles()) {
                ZipFiles.zipDirectoryInternal(file, "", zos);
            }
            zos.finish();
        }
    }

    private static void zipDirectoryInternal(@UnknownKeyFor @NonNull @Initialized File inputFile, @UnknownKeyFor @NonNull @Initialized String directoryName, @UnknownKeyFor @NonNull @Initialized ZipOutputStream zos) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String entryName = directoryName + inputFile.getName();
        if (inputFile.isDirectory()) {
            entryName = entryName + "/";
            Object[] childFiles = inputFile.listFiles();
            if (childFiles.length > 0) {
                Arrays.sort(childFiles);
                for (Object file : childFiles) {
                    ZipFiles.zipDirectoryInternal((File)file, entryName, zos);
                }
                return;
            }
        }
        ZipEntry entry = new ZipEntry(entryName);
        entry.setTime(inputFile.lastModified());
        zos.putNextEntry(entry);
        if (inputFile.isFile()) {
            Files.asByteSource((File)inputFile).copyTo((OutputStream)zos);
        }
    }

    private static final class ZipEntryByteSource
    extends ByteSource {
        private final @UnknownKeyFor @NonNull @Initialized ZipFile file;
        private final @UnknownKeyFor @NonNull @Initialized ZipEntry entry;

        ZipEntryByteSource(@UnknownKeyFor @NonNull @Initialized ZipFile file, @UnknownKeyFor @NonNull @Initialized ZipEntry entry) {
            this.file = (ZipFile)Preconditions.checkNotNull((Object)file);
            this.entry = (ZipEntry)Preconditions.checkNotNull((Object)entry);
        }

        public @UnknownKeyFor @NonNull @Initialized InputStream openStream() throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.file.getInputStream(this.entry);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "ZipFiles.asByteSource(" + this.file + ", " + this.entry + ")";
        }
    }
}

