/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput;

import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.file.EncodingType;
import org.apache.hop.core.file.IInputFileMeta;
import org.apache.hop.core.file.TextFileInputField;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.StringEvaluationResult;
import org.apache.hop.core.util.StringEvaluator;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transforms.fileinput.TextFileInput;
import org.apache.hop.pipeline.transforms.fileinput.TextFileInputMeta;
import org.apache.hop.pipeline.transforms.fileinput.TextFileLine;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.pipeline.transform.common.ICsvInputAwareImportProgressDialog;
import org.eclipse.swt.widgets.Shell;

@Deprecated
public class TextFileCSVImportProgressDialog
implements ICsvInputAwareImportProgressDialog {
    private static final Class<?> PKG = TextFileInputMeta.class;
    private Shell shell;
    private final IVariables variables;
    private IInputFileMeta meta;
    private int samples;
    private boolean replaceMeta;
    private String message;
    private String debug;
    private long rownumber;
    private InputStreamReader reader;
    private PipelineMeta pipelineMeta;
    private ILogChannel log;
    private EncodingType encodingType;

    public TextFileCSVImportProgressDialog(Shell shell, IVariables variables, IInputFileMeta meta, PipelineMeta pipelineMeta, InputStreamReader reader, int samples, boolean replaceMeta) {
        this.shell = shell;
        this.variables = variables;
        this.meta = meta;
        this.reader = reader;
        this.samples = samples;
        this.replaceMeta = replaceMeta;
        this.pipelineMeta = pipelineMeta;
        this.message = null;
        this.debug = "init";
        this.rownumber = 1L;
        this.log = new LogChannel((Object)pipelineMeta);
        this.encodingType = EncodingType.guessEncodingType((String)reader.getEncoding());
    }

    public String open() {
        return this.open(true);
    }

    public String open(boolean failOnParseError) {
        IRunnableWithProgress op = monitor -> {
            try {
                this.message = this.doScan(monitor, failOnParseError);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvocationTargetException(e, BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Exception.ErrorScanningFile", (String[])new String[]{"" + this.rownumber, this.debug, e.toString()}));
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), (Exception)e);
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), (Exception)e);
        }
        return this.message;
    }

    private String doScan(IProgressMonitor monitor) throws HopException {
        return this.doScan(monitor, true);
    }

    private String doScan(IProgressMonitor monitor, boolean failOnParseError) throws HopException {
        if (this.samples > 0) {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Task.ScanningFile", (String[])new String[0]), this.samples + 1);
        } else {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Task.ScanningFile", (String[])new String[0]), 2);
        }
        String line = "";
        long fileLineNumber = 0L;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        int nrFields = this.meta.getInputFields().length;
        RowMeta outputRowMeta = new RowMeta();
        this.meta.getFields((IRowMeta)outputRowMeta, null, null, null, this.variables, null);
        for (IValueMeta valueMeta : outputRowMeta.getValueMetaList()) {
            valueMeta.setStorageMetadata(null);
            valueMeta.setStorageType(0);
        }
        IRowMeta convertRowMeta = outputRowMeta.cloneToType(2);
        int[] nrnull = new int[nrFields];
        String[] minstr = new String[nrFields];
        String[] maxstr = new String[nrFields];
        boolean[] firststr = new boolean[nrFields];
        boolean[] isDate = new boolean[nrFields];
        int[] dateFormatCount = new int[nrFields];
        boolean[][] dateFormat = new boolean[nrFields][Const.getDateFormats().length];
        Date[][] minDate = new Date[nrFields][Const.getDateFormats().length];
        Date[][] maxDate = new Date[nrFields][Const.getDateFormats().length];
        boolean[] isNumber = new boolean[nrFields];
        int[] numberFormatCount = new int[nrFields];
        boolean[][] numberFormat = new boolean[nrFields][Const.getNumberFormats().length];
        double[][] minValue = new double[nrFields][Const.getDateFormats().length];
        double[][] maxValue = new double[nrFields][Const.getDateFormats().length];
        int[][] numberPrecision = new int[nrFields][Const.getNumberFormats().length];
        int[][] numberLength = new int[nrFields][Const.getNumberFormats().length];
        for (int i = 0; i < nrFields; ++i) {
            int j;
            TextFileInputField field = this.meta.getInputFields()[i];
            if (this.log.isDebug()) {
                this.debug = "init field #" + i;
            }
            if (this.replaceMeta) {
                field.setName(this.meta.getInputFields()[i].getName());
                field.setType(this.meta.getInputFields()[i].getType());
                field.setFormat("");
                field.setLength(-1);
                field.setPrecision(-1);
                field.setCurrencySymbol(dfs.getCurrencySymbol());
                field.setDecimalSymbol("" + dfs.getDecimalSeparator());
                field.setGroupSymbol("" + dfs.getGroupingSeparator());
                field.setNullString("-");
                field.setTrimType(0);
            }
            nrnull[i] = 0;
            minstr[i] = "";
            maxstr[i] = "";
            firststr[i] = true;
            isDate[i] = true;
            for (j = 0; j < Const.getDateFormats().length; ++j) {
                dateFormat[i][j] = true;
                minDate[i][j] = Const.MAX_DATE;
                maxDate[i][j] = Const.MIN_DATE;
            }
            dateFormatCount[i] = Const.getDateFormats().length;
            isNumber[i] = true;
            for (j = 0; j < Const.getNumberFormats().length; ++j) {
                numberFormat[i][j] = true;
                minValue[i][j] = Double.MAX_VALUE;
                maxValue[i][j] = -1.7976931348623157E308;
                numberPrecision[i][j] = -1;
                numberLength[i][j] = -1;
            }
            numberFormatCount[i] = Const.getNumberFormats().length;
        }
        IInputFileMeta strinfo = (IInputFileMeta)this.meta.clone();
        for (int i = 0; i < nrFields; ++i) {
            strinfo.getInputFields()[i].setType(2);
        }
        this.debug = "get first line";
        StringBuilder lineBuffer = new StringBuilder(256);
        int fileFormatType = this.meta.getFileFormatTypeNr();
        line = TextFileInput.getLine(this.log, this.reader, this.encodingType, fileFormatType, lineBuffer);
        ++fileLineNumber;
        if (this.meta.hasHeader()) {
            int skipped = 0;
            while (line != null && skipped < this.meta.getNrHeaderLines()) {
                line = TextFileInput.getLine(this.log, this.reader, this.encodingType, fileFormatType, lineBuffer);
                ++skipped;
                ++fileLineNumber;
            }
        }
        int linenr = 1;
        ArrayList<StringEvaluator> evaluators = new ArrayList<StringEvaluator>();
        DecimalFormat df2 = (DecimalFormat)NumberFormat.getInstance();
        DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
        SimpleDateFormat daf2 = new SimpleDateFormat();
        boolean errorFound = false;
        while (!(errorFound || line == null || linenr > this.samples && this.samples != 0 || monitor.isCanceled())) {
            monitor.subTask(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Task.ScanningLine", (String[])new String[]{"" + linenr}));
            if (this.samples > 0) {
                monitor.worked(1);
            }
            if (this.log.isDebug()) {
                this.debug = "convert line #" + linenr + " to row";
            }
            RowMeta rowMeta = new RowMeta();
            this.meta.getFields((IRowMeta)rowMeta, "transformName", null, null, this.variables, null);
            for (IValueMeta valueMeta : rowMeta.getValueMetaList()) {
                valueMeta.setStorageMetadata(null);
                valueMeta.setStorageType(0);
            }
            String delimiter = this.variables.resolve(this.meta.getSeparator());
            String enclosure = this.variables.resolve(this.meta.getEnclosure());
            String escapeCharacter = this.variables.resolve(this.meta.getEscapeCharacter());
            Object[] r = TextFileInput.convertLineToRow(this.log, new TextFileLine(line, fileLineNumber, null), strinfo, null, 0, (IRowMeta)outputRowMeta, convertRowMeta, this.meta.getFilePaths(this.variables)[0], this.rownumber, delimiter, enclosure, escapeCharacter, null, false, false, false, false, false, false, false, false, null, null, false, null, null, null, null, 0L, failOnParseError);
            if (r == null) {
                errorFound = true;
                continue;
            }
            ++this.rownumber;
            for (int i = 0; i < nrFields && i < r.length; ++i) {
                StringEvaluator evaluator;
                if (i >= evaluators.size()) {
                    evaluator = new StringEvaluator(true);
                    evaluators.add(evaluator);
                } else {
                    evaluator = (StringEvaluator)evaluators.get(i);
                }
                String string = this.getStringFromRow((IRowMeta)rowMeta, r, i, failOnParseError);
                if (i == 0) {
                    System.out.println();
                }
                evaluator.evaluateString(string);
            }
            ++fileLineNumber;
            if (r != null) {
                ++linenr;
            }
            line = TextFileInput.getLine(this.log, this.reader, this.encodingType, fileFormatType, lineBuffer);
        }
        monitor.worked(1);
        monitor.setTaskName(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Task.AnalyzingResults", (String[])new String[0]));
        StringBuilder message = new StringBuilder();
        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.ResultAfterScanning", (String[])new String[]{"" + (linenr - 1)}));
        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.HorizontalLine", (String[])new String[0]));
        for (int i = 0; i < nrFields; ++i) {
            TextFileInputField field = this.meta.getInputFields()[i];
            StringEvaluator evaluator = (StringEvaluator)evaluators.get(i);
            List evaluationResults = evaluator.getStringEvaluationResults();
            StringEvaluationResult result = evaluator.getAdvicedResult();
            if (evaluationResults.isEmpty()) {
                field.setType(2);
                field.setLength(evaluator.getMaxLength());
            }
            if (result != null) {
                IValueMeta conversionMeta = result.getConversionMeta();
                field.setType(conversionMeta.getType());
                field.setTrimType(conversionMeta.getTrimType());
                field.setFormat(conversionMeta.getConversionMask());
                field.setDecimalSymbol(conversionMeta.getDecimalSymbol());
                field.setGroupSymbol(conversionMeta.getGroupingSymbol());
                field.setLength(conversionMeta.getLength());
                field.setPrecision(conversionMeta.getPrecision());
                nrnull[i] = result.getNrNull();
                minstr[i] = result.getMin() == null ? "" : result.getMin().toString();
                maxstr[i] = result.getMax() == null ? "" : result.getMax().toString();
            }
            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.FieldNumber", (String[])new String[]{"" + (i + 1)}));
            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.FieldName", (String[])new String[]{field.getName()}));
            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.FieldType", (String[])new String[]{field.getTypeDesc()}));
            switch (field.getType()) {
                case 1: {
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.EstimatedLength", (String[])new String[]{field.getLength() < 0 ? "-" : "" + field.getLength()}));
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.EstimatedPrecision", (String[])new String[]{field.getPrecision() < 0 ? "-" : "" + field.getPrecision()}));
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberFormat", (String[])new String[]{field.getFormat()}));
                    if (!evaluationResults.isEmpty()) {
                        if (evaluationResults.size() > 1) {
                            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.WarnNumberFormat", (String[])new String[0]));
                        }
                        for (StringEvaluationResult seResult : evaluationResults) {
                            String mask = seResult.getConversionMeta().getConversionMask();
                            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberFormat2", (String[])new String[]{mask}));
                            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.TrimType", (Object[])new Object[]{seResult.getConversionMeta().getTrimType()}));
                            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberMinValue", (Object[])new Object[]{seResult.getMin()}));
                            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberMaxValue", (Object[])new Object[]{seResult.getMax()}));
                            try {
                                df2.applyPattern(mask);
                                df2.setDecimalFormatSymbols(dfs2);
                                double mn = df2.parse(seResult.getMin().toString()).doubleValue();
                                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberExample", (Object[])new Object[]{mask, seResult.getMin(), Double.toString(mn)}));
                            }
                            catch (Exception e) {
                                if (!this.log.isDetailed()) continue;
                                this.log.logDetailed("This is unexpected: parsing [" + String.valueOf(seResult.getMin()) + "] with format [" + mask + "] did not work.");
                            }
                        }
                    }
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.NumberNrNullValues", (String[])new String[]{"" + nrnull[i]}));
                    break;
                }
                case 2: {
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.StringMaxLength", (String[])new String[]{"" + field.getLength()}));
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.StringMinValue", (String[])new String[]{minstr[i]}));
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.StringMaxValue", (String[])new String[]{maxstr[i]}));
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.StringNrNullValues", (String[])new String[]{"" + nrnull[i]}));
                    break;
                }
                case 3: {
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateMaxLength", (String[])new String[]{field.getLength() < 0 ? "-" : "" + field.getLength()}));
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateFormat", (String[])new String[]{field.getFormat()}));
                    if (dateFormatCount[i] > 1) {
                        message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.WarnDateFormat", (String[])new String[0]));
                    }
                    if (!Utils.isEmpty((CharSequence)minstr[i])) {
                        for (int x = 0; x < Const.getDateFormats().length; ++x) {
                            if (!dateFormat[i][x]) continue;
                            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateFormat2", (String[])new String[]{Const.getDateFormats()[x]}));
                            Date mindate = minDate[i][x];
                            Date maxdate = maxDate[i][x];
                            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateMinValue", (String[])new String[]{mindate.toString()}));
                            message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateMaxValue", (String[])new String[]{maxdate.toString()}));
                            daf2.applyPattern(Const.getDateFormats()[x]);
                            try {
                                Date md = daf2.parse(minstr[i]);
                                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateExample", (String[])new String[]{Const.getDateFormats()[x], minstr[i], md.toString()}));
                                continue;
                            }
                            catch (Exception e) {
                                if (!this.log.isDetailed()) continue;
                                this.log.logDetailed("This is unexpected: parsing [" + minstr[i] + "] with format [" + Const.getDateFormats()[x] + "] did not work.");
                            }
                        }
                    }
                    message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.DateNrNullValues", (String[])new String[]{"" + nrnull[i]}));
                    break;
                }
            }
            if (nrnull[i] == linenr - 1) {
                message.append(BaseMessages.getString(PKG, (String)"TextFileCSVImportProgressDialog.Info.AllNullValues", (String[])new String[0]));
            }
            message.append(Const.CR);
        }
        monitor.worked(1);
        monitor.done();
        return message.toString();
    }
}

