/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.execution.path;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.Const;

public class PathResult {
    public static final String CONST_TYPE = "\", type : \"";
    public static final String CONST_ID = "\", id : \"";
    private String id;
    private String name;
    private String type;
    private String copy;
    private Date registrationDate;
    private Boolean failed;
    private List<List<PathResult>> shortestPaths = new ArrayList<List<PathResult>>();
    private Boolean root;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public Boolean getRoot() {
        return this.root;
    }

    public String getCopy() {
        return this.copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }

    public Boolean getFailed() {
        return this.failed;
    }

    public void setFailed(Boolean failed) {
        this.failed = failed;
    }

    public List<List<PathResult>> getShortestPaths() {
        return this.shortestPaths;
    }

    public void setShortestPaths(List<List<PathResult>> shortestPaths) {
        this.shortestPaths = shortestPaths;
    }

    public void setRoot(Boolean root) {
        this.root = root;
    }

    public Boolean isRoot() {
        return this.root;
    }

    public String getExecutionInfoCommand() {
        StringBuilder cmd = new StringBuilder();
        cmd.append("MATCH(ex:Execution { name : \"" + this.getName() + CONST_TYPE + this.getType() + CONST_ID + this.getId() + "\"}) ").append(Const.CR);
        cmd.append("RETURN ex ").append(Const.CR);
        return cmd.toString();
    }

    public String getErrorPathCommand() {
        StringBuilder cmd = new StringBuilder();
        cmd.append("MATCH(top:Execution { name : \"" + this.getName() + CONST_TYPE + this.getType() + CONST_ID + this.getId() + "\"})-[rel:EXECUTES*]-(err:Execution) ").append(Const.CR);
        cmd.append("   , p=shortestpath((top)-[:EXECUTES*]-(err)) ").append(Const.CR);
        cmd.append("WHERE top.registrationDate IS NOT NULL ").append(Const.CR);
        cmd.append("  AND err.errors > 0 ").append(Const.CR);
        cmd.append("  AND size((err)-[:EXECUTES]->())=0 ").append(Const.CR);
        cmd.append("RETURN p ").append(Const.CR);
        cmd.append("ORDER BY size(RELATIONSHIPS(p)) DESC ").append(Const.CR);
        cmd.append("LIMIT 5").append(Const.CR);
        return cmd.toString();
    }

    public String getErrorPathWithMetadataCommand(int pathIndex) {
        StringBuilder cmd = new StringBuilder();
        cmd.append("MATCH(top:Execution { name : \"" + this.getName() + CONST_TYPE + this.getType() + CONST_ID + this.getId() + "\"})-[rel:EXECUTES*]-(err:Execution) ").append(Const.CR);
        cmd.append("   , p=shortestpath((top)-[:EXECUTES*]-(err)) ").append(Const.CR);
        cmd.append("WHERE top.registrationDate IS NOT NULL ").append(Const.CR);
        cmd.append("  AND err.errors > 0 ").append(Const.CR);
        cmd.append("  AND size((err)-[:EXECUTES]->())=0 ").append(Const.CR);
        StringBuilder returns = new StringBuilder("RETURN p");
        int matchIndex = 1;
        List<PathResult> shortestPath = this.getShortestPaths().get(pathIndex);
        for (PathResult result : shortestPath) {
            String metaLabel = null;
            if (result.getType().equals("PIPELINE")) {
                metaLabel = "Pipeline";
            } else if (result.getType().equals("WORKFLOW")) {
                metaLabel = "Workflow";
            } else if (result.getType().equals("ACTION")) {
                metaLabel = "Action";
            } else if (result.getType().equals("TRANSFORM")) {
                metaLabel = "Transform";
            }
            if (metaLabel == null) continue;
            cmd.append("MATCH (:Execution { type : \"" + result.getType() + CONST_ID + result.getId() + "\"})-[metaRel" + matchIndex + "]->(meta" + matchIndex + ":" + metaLabel + ") ").append(Const.CR);
            returns.append(", metaRel" + matchIndex + ", meta" + matchIndex);
            ++matchIndex;
        }
        cmd.append(returns.toString()).append(" ").append(Const.CR);
        cmd.append("LIMIT 1 ").append(Const.CR);
        return cmd.toString();
    }
}

