/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodboutput;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutputData;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutputMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MongoDbOutputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = MongoDbOutputMeta.class;
    public static final String CONST_MONGO_DB_OUTPUT_DIALOG_FIELDS_NULL_VALUES_INSERT = "MongoDbOutputDialog.Fields.NullValues.Insert";
    public static final String CONST_MONGO_DB_OUTPUT_DIALOG_ERROR_MESSAGE_UNABLE_TO_CONNECT = "MongoDbOutputDialog.ErrorMessage.UnableToConnect";
    public static final String CONST_NEWLING = ":\n\n";
    protected MongoDbOutputMeta currentMeta;
    protected MongoDbOutputMeta originalMeta;
    private MetaSelectionLine<MongoDbConnection> wConnection;
    private CCombo wCollectionField;
    private TextVar wBatchInsertSizeField;
    private Button wbTruncate;
    private Button wbUpdate;
    private Button wbUpsert;
    private Button wbMulti;
    private Button wbModifierUpdate;
    private TextVar wWriteRetries;
    private TextVar wWriteRetryDelay;
    private TableView wMongoFields;
    private TableView wMongoIndexes;

    public MongoDbOutputDialog(Shell parent, IVariables variables, MongoDbOutputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.currentMeta = transformMeta;
        this.originalMeta = (MongoDbOutputMeta)((Object)this.currentMeta.clone());
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.currentMeta);
        ModifyListener lsMod = e -> this.currentMeta.setChanged();
        this.changed = this.currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)fd);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fd);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wOutputOptionsTab = new CTabItem(wTabFolder, 0);
        wOutputOptionsTab.setFont(GuiResource.getInstance().getFontDefault());
        wOutputOptionsTab.setText("Output options");
        Composite wOutputComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wOutputComp);
        FormLayout outputLayout = new FormLayout();
        outputLayout.marginWidth = 3;
        outputLayout.marginHeight = 3;
        wOutputComp.setLayout((Layout)outputLayout);
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, MongoDbConnection.class, wOutputComp, 0, BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ConnectionName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ConnectionName.Tooltip", (String[])new String[0]));
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment(0, 0);
        this.wConnection.setLayoutData((Object)fdConnection);
        Button lastControl = this.wConnection;
        try {
            this.wConnection.fillItems();
        }
        catch (HopException e2) {
            new ErrorDialog(this.shell, "Error", "Error loading list of MongoDB connection names", (Exception)((Object)e2));
        }
        Label collectionLab = new Label(wOutputComp, 131072);
        collectionLab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Collection.Label", (String[])new String[0]));
        collectionLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Collection.TipText", (String[])new String[0]));
        PropsUi.setLook((Widget)collectionLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(lastControl, margin);
        fd.right = new FormAttachment(middle, -margin);
        collectionLab.setLayoutData((Object)fd);
        Button wbGetCollections = new Button(wOutputComp, 0x1000008);
        PropsUi.setLook((Widget)wbGetCollections);
        wbGetCollections.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.GetCollections.Button", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)collectionLab, 0, 0x1000000);
        wbGetCollections.setLayoutData((Object)fd);
        wbGetCollections.addListener(13, e -> this.getCollectionNames(false));
        this.wCollectionField = new CCombo(wOutputComp, 2048);
        PropsUi.setLook((Widget)this.wCollectionField);
        this.wCollectionField.addModifyListener(e -> {
            this.currentMeta.setChanged();
            this.wCollectionField.setToolTipText(this.variables.resolve(this.wCollectionField.getText()));
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)collectionLab, 0, 0x1000000);
        fd.right = new FormAttachment((Control)wbGetCollections, -margin);
        this.wCollectionField.setLayoutData((Object)fd);
        lastControl = wbGetCollections;
        Label batchLab = new Label(wOutputComp, 131072);
        batchLab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.BatchInsertSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)batchLab);
        batchLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.BatchInsertSize.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)lastControl, margin);
        fd.right = new FormAttachment(middle, -margin);
        batchLab.setLayoutData((Object)fd);
        this.wBatchInsertSizeField = new TextVar(this.variables, wOutputComp, 18436);
        PropsUi.setLook((Widget)this.wBatchInsertSizeField);
        this.wBatchInsertSizeField.addModifyListener(lsMod);
        this.wBatchInsertSizeField.addModifyListener(e -> this.wBatchInsertSizeField.setToolTipText(this.variables.resolve(this.wBatchInsertSizeField.getText())));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)batchLab, 0, 0x1000000);
        fd.left = new FormAttachment(middle, 0);
        this.wBatchInsertSizeField.setLayoutData((Object)fd);
        lastControl = this.wBatchInsertSizeField;
        Label truncateLab = new Label(wOutputComp, 131072);
        truncateLab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Truncate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)truncateLab);
        truncateLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Truncate.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)lastControl, 2 * margin);
        fd.right = new FormAttachment(middle, -margin);
        truncateLab.setLayoutData((Object)fd);
        this.wbTruncate = new Button(wOutputComp, 32);
        PropsUi.setLook((Widget)this.wbTruncate);
        this.wbTruncate.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Truncate.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)truncateLab, 0, 0x1000000);
        fd.left = new FormAttachment(middle, 0);
        this.wbTruncate.setLayoutData((Object)fd);
        this.wbTruncate.addListener(13, e -> this.currentMeta.setChanged());
        lastControl = truncateLab;
        Label updateLab = new Label(wOutputComp, 131072);
        updateLab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Update.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)updateLab);
        updateLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Update.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)lastControl, 2 * margin);
        fd.right = new FormAttachment(middle, -margin);
        updateLab.setLayoutData((Object)fd);
        this.wbUpdate = new Button(wOutputComp, 32);
        PropsUi.setLook((Widget)this.wbUpdate);
        this.wbUpdate.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Update.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)updateLab, 0, 0x1000000);
        fd.left = new FormAttachment(middle, 0);
        this.wbUpdate.setLayoutData((Object)fd);
        lastControl = updateLab;
        this.wbUpdate.addListener(13, e -> {
            this.currentMeta.setChanged();
            this.wbUpsert.setEnabled(this.wbUpdate.getSelection());
            this.wbModifierUpdate.setEnabled(this.wbUpdate.getSelection());
            this.wbMulti.setEnabled(this.wbUpdate.getSelection());
            if (!this.wbUpdate.getSelection()) {
                this.wbModifierUpdate.setSelection(false);
                this.wbMulti.setSelection(false);
                this.wbUpsert.setSelection(false);
            }
            this.wbMulti.setEnabled(this.wbModifierUpdate.getSelection());
            if (!this.wbMulti.getEnabled()) {
                this.wbMulti.setSelection(false);
            }
        });
        Label upsertLab = new Label(wOutputComp, 131072);
        upsertLab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Upsert.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)upsertLab);
        upsertLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Upsert.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)lastControl, 2 * margin);
        fd.right = new FormAttachment(middle, -margin);
        upsertLab.setLayoutData((Object)fd);
        this.wbUpsert = new Button(wOutputComp, 32);
        PropsUi.setLook((Widget)this.wbUpsert);
        this.wbUpsert.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Upsert.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)upsertLab, 0, 0x1000000);
        fd.left = new FormAttachment(middle, 0);
        this.wbUpsert.setLayoutData((Object)fd);
        lastControl = upsertLab;
        Label multiLab = new Label(wOutputComp, 131072);
        multiLab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Multi.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)multiLab);
        multiLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Multi.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)lastControl, 2 * margin);
        fd.right = new FormAttachment(middle, -margin);
        multiLab.setLayoutData((Object)fd);
        this.wbMulti = new Button(wOutputComp, 32);
        PropsUi.setLook((Widget)this.wbMulti);
        this.wbMulti.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Multi.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)multiLab, 0, 0x1000000);
        fd.left = new FormAttachment(middle, 0);
        this.wbMulti.setLayoutData((Object)fd);
        this.wbMulti.addListener(13, e -> this.currentMeta.setChanged());
        lastControl = multiLab;
        Label modifierLab = new Label(wOutputComp, 131072);
        modifierLab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Modifier.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)modifierLab);
        modifierLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Modifier.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)lastControl, 2 * margin);
        fd.right = new FormAttachment(middle, -margin);
        modifierLab.setLayoutData((Object)fd);
        this.wbModifierUpdate = new Button(wOutputComp, 32);
        PropsUi.setLook((Widget)this.wbModifierUpdate);
        this.wbModifierUpdate.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Modifier.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)modifierLab, 0, 0x1000000);
        fd.left = new FormAttachment(middle, 0);
        this.wbModifierUpdate.setLayoutData((Object)fd);
        this.wbModifierUpdate.addListener(13, e -> {
            this.currentMeta.setChanged();
            this.wbMulti.setEnabled(this.wbModifierUpdate.getSelection());
            if (!this.wbModifierUpdate.getSelection()) {
                this.wbMulti.setSelection(false);
            }
        });
        lastControl = modifierLab;
        Label retriesLab = new Label(wOutputComp, 131072);
        PropsUi.setLook((Widget)retriesLab);
        retriesLab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.WriteRetries.Label", (String[])new String[0]));
        retriesLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.WriteRetries.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, -margin);
        fd.top = new FormAttachment((Control)lastControl, margin);
        fd.right = new FormAttachment(middle, -margin);
        retriesLab.setLayoutData((Object)fd);
        this.wWriteRetries = new TextVar(this.variables, wOutputComp, 18436);
        PropsUi.setLook((Widget)this.wWriteRetries);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)retriesLab, 0, 0x1000000);
        fd.right = new FormAttachment(100, 0);
        this.wWriteRetries.setLayoutData((Object)fd);
        this.wWriteRetries.addModifyListener(e -> this.wWriteRetries.setToolTipText(this.variables.resolve(this.wWriteRetries.getText())));
        Label retriesDelayLab = new Label(wOutputComp, 131072);
        PropsUi.setLook((Widget)retriesDelayLab);
        retriesDelayLab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.WriteRetriesDelay.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, -margin);
        fd.top = new FormAttachment((Control)this.wWriteRetries, margin);
        fd.right = new FormAttachment(middle, -margin);
        retriesDelayLab.setLayoutData((Object)fd);
        this.wWriteRetryDelay = new TextVar(this.variables, wOutputComp, 18436);
        PropsUi.setLook((Widget)this.wWriteRetryDelay);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.wWriteRetries, margin);
        fd.right = new FormAttachment(100, 0);
        this.wWriteRetryDelay.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wOutputComp.setLayoutData((Object)fd);
        wOutputComp.layout();
        wOutputOptionsTab.setControl((Control)wOutputComp);
        CTabItem wMongoFieldsTab = new CTabItem(wTabFolder, 0);
        wMongoFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wMongoFieldsTab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComp);
        FormLayout filterLayout = new FormLayout();
        filterLayout.marginWidth = 3;
        filterLayout.marginHeight = 3;
        wFieldsComp.setLayout((Layout)filterLayout);
        ColumnInfo[] colInf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Fields.Incoming", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Fields.Path", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Fields.UseIncomingName", (String[])new String[0]), 2, new String[]{"Y", "N"}), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Fields.NullValues", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)CONST_MONGO_DB_OUTPUT_DIALOG_FIELDS_NULL_VALUES_INSERT, (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Fields.NullValues.Ignore", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Fields.JSON", (String[])new String[0]), 2, new String[]{"Y", "N"}), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Fields.UpdateMatchField", (String[])new String[0]), 2, new String[]{"Y", "N"}), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Fields.ModifierUpdateOperation", (String[])new String[0]), 2, new String[]{"N/A", "$set", "$inc", "$push"}), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Fields.ModifierApplyPolicy", (String[])new String[0]), 2, new String[]{"Insert&Update", "Insert", "Update"})};
        Button wbGetFields = new Button(wFieldsComp, 0x1000008);
        PropsUi.setLook((Widget)wbGetFields);
        wbGetFields.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.GetFieldsBut", (String[])new String[0]));
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.left = new FormAttachment(0, margin);
        wbGetFields.setLayoutData((Object)fd);
        wbGetFields.addListener(13, e -> this.getFields());
        Button wbPreviewDocStruct = new Button(wFieldsComp, 0x1000008);
        PropsUi.setLook((Widget)wbPreviewDocStruct);
        wbPreviewDocStruct.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.PreviewDocStructBut", (String[])new String[0]));
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.left = new FormAttachment((Control)wbGetFields, margin);
        wbPreviewDocStruct.setLayoutData((Object)fd);
        wbPreviewDocStruct.addListener(13, e -> this.previewDocStruct());
        this.wMongoFields = new TableView(this.variables, wFieldsComp, 65538, colInf, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment(0, margin * 2);
        fd.bottom = new FormAttachment((Control)wbGetFields, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.wMongoFields.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fd);
        wFieldsComp.layout();
        wMongoFieldsTab.setControl((Control)wFieldsComp);
        CTabItem wMongoIndexesTab = new CTabItem(wTabFolder, 0);
        wMongoIndexesTab.setFont(GuiResource.getInstance().getFontDefault());
        wMongoIndexesTab.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.IndexesTab.TabTitle", (String[])new String[0]));
        Composite wIndexesComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wIndexesComp);
        FormLayout indexesLayout = new FormLayout();
        indexesLayout.marginWidth = 3;
        indexesLayout.marginHeight = 3;
        wIndexesComp.setLayout((Layout)indexesLayout);
        ColumnInfo[] colInf2 = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Indexes.IndexFields", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Indexes.IndexOpp", (String[])new String[0]), 2, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Indexes.Unique", (String[])new String[0]), 2, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Indexes.Sparse", (String[])new String[0]), 2, false)};
        colInf2[1].setComboValues(new String[]{"Create", "Drop"});
        colInf2[1].setReadOnly(true);
        colInf2[2].setComboValues(new String[]{"Y", "N"});
        colInf2[2].setReadOnly(true);
        colInf2[3].setComboValues(new String[]{"Y", "N"});
        colInf2[3].setReadOnly(true);
        Button wbShowIndexes = new Button(wIndexesComp, 0x1000008);
        PropsUi.setLook((Widget)wbShowIndexes);
        wbShowIndexes.setText(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ShowIndexesBut", (String[])new String[0]));
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.left = new FormAttachment(0, margin);
        wbShowIndexes.setLayoutData((Object)fd);
        wbShowIndexes.addListener(13, e -> this.showIndexInfo());
        this.wMongoIndexes = new TableView(this.variables, wIndexesComp, 65538, colInf2, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment(0, margin * 2);
        fd.bottom = new FormAttachment((Control)wbShowIndexes, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.wMongoIndexes.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wIndexesComp.setLayoutData((Object)fd);
        wIndexesComp.layout();
        wMongoIndexesTab.setControl((Control)wIndexesComp);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wTransformName, margin);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fd);
        wTabFolder.setSelection(0);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void cancel() {
        this.transformName = null;
        this.currentMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.currentMeta);
        if (this.currentMeta.getMongoFields() == null) {
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ErrorMessage.NoFieldPathsDefined.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ErrorMessage.NoFieldPathsDefined", (String[])new String[0]));
            smd.open();
        }
        if (!((Object)((Object)this.originalMeta)).equals((Object)this.currentMeta)) {
            this.currentMeta.setChanged();
            this.changed = this.currentMeta.hasChanged();
        }
        this.dispose();
    }

    private void getInfo(MongoDbOutputMeta meta) {
        meta.setConnectionName(this.wConnection.getText());
        meta.setCollection(this.wCollectionField.getText());
        meta.setBatchInsertSize(this.wBatchInsertSizeField.getText());
        meta.setUpdate(this.wbUpdate.getSelection());
        meta.setUpsert(this.wbUpsert.getSelection());
        meta.setMulti(this.wbMulti.getSelection());
        meta.setTruncate(this.wbTruncate.getSelection());
        meta.setModifierUpdate(this.wbModifierUpdate.getSelection());
        meta.setWriteRetries(this.wWriteRetries.getText());
        meta.setWriteRetryDelay(this.wWriteRetryDelay.getText());
        meta.setMongoFields(this.tableToMongoFieldList());
        int numNonEmpty = this.wMongoIndexes.nrNonEmpty();
        ArrayList<MongoDbOutputMeta.MongoIndex> mongoIndexes = new ArrayList<MongoDbOutputMeta.MongoIndex>();
        if (numNonEmpty > 0) {
            for (int i = 0; i < numNonEmpty; ++i) {
                TableItem item = this.wMongoIndexes.getNonEmpty(i);
                String indexFieldList = item.getText(1).trim();
                String indexOpp = item.getText(2).trim();
                String unique = item.getText(3).trim();
                String sparse = item.getText(4).trim();
                MongoDbOutputMeta.MongoIndex newIndex = new MongoDbOutputMeta.MongoIndex();
                newIndex.pathToFields = indexFieldList;
                newIndex.drop = indexOpp.equals("Drop");
                newIndex.unique = unique.equals("Y");
                newIndex.sparse = sparse.equals("Y");
                mongoIndexes.add(newIndex);
            }
        }
        meta.setMongoIndexes(mongoIndexes);
    }

    private List<MongoDbOutputMeta.MongoField> tableToMongoFieldList() {
        int numNonEmpty = this.wMongoFields.nrNonEmpty();
        if (numNonEmpty > 0) {
            ArrayList<MongoDbOutputMeta.MongoField> mongoFields = new ArrayList<MongoDbOutputMeta.MongoField>(numNonEmpty);
            for (int i = 0; i < numNonEmpty; ++i) {
                TableItem item = this.wMongoFields.getNonEmpty(i);
                String incoming = item.getText(1).trim();
                String path = item.getText(2).trim();
                String useIncoming = item.getText(3).trim();
                String allowNull = item.getText(4).trim();
                String json = item.getText(5).trim();
                String updateMatch = item.getText(6).trim();
                String modifierOp = item.getText(7).trim();
                String modifierPolicy = item.getText(8).trim();
                MongoDbOutputMeta.MongoField newField = new MongoDbOutputMeta.MongoField();
                newField.incomingFieldName = incoming;
                newField.mongoDocPath = path;
                newField.useIncomingFieldNameAsMongoFieldName = useIncoming.length() > 0 ? useIncoming.equals("Y") : true;
                newField.insertNull = BaseMessages.getString(PKG, (String)CONST_MONGO_DB_OUTPUT_DIALOG_FIELDS_NULL_VALUES_INSERT, (String[])new String[0]).equals(allowNull);
                newField.inputJson = json.length() > 0 ? json.equals("Y") : false;
                newField.updateMatchField = updateMatch.equals("Y");
                newField.modifierUpdateOperation = modifierOp.length() == 0 ? "N/A" : modifierOp;
                newField.modifierOperationApplyPolicy = modifierPolicy;
                mongoFields.add(newField);
            }
            return mongoFields;
        }
        return null;
    }

    private void getData() {
        List<MongoDbOutputMeta.MongoIndex> mongoIndexes;
        this.wConnection.setText(Const.NVL((String)this.currentMeta.getConnectionName(), (String)""));
        this.wCollectionField.setText(Const.NVL((String)this.currentMeta.getCollection(), (String)""));
        this.wBatchInsertSizeField.setText(Const.NVL((String)this.currentMeta.getBatchInsertSize(), (String)""));
        this.wbUpdate.setSelection(this.currentMeta.getUpdate());
        this.wbUpsert.setSelection(this.currentMeta.getUpsert());
        this.wbMulti.setSelection(this.currentMeta.getMulti());
        this.wbTruncate.setSelection(this.currentMeta.getTruncate());
        this.wbModifierUpdate.setSelection(this.currentMeta.getModifierUpdate());
        this.wbUpsert.setEnabled(this.wbUpdate.getSelection());
        this.wbModifierUpdate.setEnabled(this.wbUpdate.getSelection());
        this.wbMulti.setEnabled(this.wbUpdate.getSelection());
        if (!this.wbUpdate.getSelection()) {
            this.wbModifierUpdate.setSelection(false);
            this.wbMulti.setSelection(false);
        }
        this.wbMulti.setEnabled(this.wbModifierUpdate.getSelection());
        if (!this.wbMulti.getEnabled()) {
            this.wbMulti.setSelection(false);
        }
        this.wWriteRetries.setText(Const.NVL((String)this.currentMeta.getWriteRetries(), (String)"5"));
        this.wWriteRetryDelay.setText(Const.NVL((String)this.currentMeta.getWriteRetryDelay(), (String)"5"));
        List<MongoDbOutputMeta.MongoField> mongoFields = this.currentMeta.getMongoFields();
        if (mongoFields != null && !mongoFields.isEmpty()) {
            for (MongoDbOutputMeta.MongoField field : mongoFields) {
                TableItem item = new TableItem(this.wMongoFields.table, 0);
                item.setText(1, Const.NVL((String)field.incomingFieldName, (String)""));
                item.setText(2, Const.NVL((String)field.mongoDocPath, (String)""));
                item.setText(3, field.useIncomingFieldNameAsMongoFieldName ? "Y" : "N");
                String insertNullString = field.insertNull ? BaseMessages.getString(PKG, (String)CONST_MONGO_DB_OUTPUT_DIALOG_FIELDS_NULL_VALUES_INSERT, (String[])new String[0]) : BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.Fields.NullValues.Ignore", (String[])new String[0]);
                item.setText(4, insertNullString);
                item.setText(5, field.inputJson ? "Y" : "N");
                item.setText(6, field.updateMatchField ? "Y" : "N");
                item.setText(7, Const.NVL((String)field.modifierUpdateOperation, (String)""));
                item.setText(8, Const.NVL((String)field.modifierOperationApplyPolicy, (String)""));
            }
            this.wMongoFields.removeEmptyRows();
            this.wMongoFields.setRowNums();
            this.wMongoFields.optWidth(true);
        }
        if ((mongoIndexes = this.currentMeta.getMongoIndexes()) != null && !mongoIndexes.isEmpty()) {
            for (MongoDbOutputMeta.MongoIndex index : mongoIndexes) {
                TableItem item = new TableItem(this.wMongoIndexes.table, 0);
                item.setText(1, Const.NVL((String)index.pathToFields, (String)""));
                if (index.drop) {
                    item.setText(2, "Drop");
                } else {
                    item.setText(2, "Create");
                }
                item.setText(3, Const.NVL((String)(index.unique ? "Y" : "N"), (String)"N"));
                item.setText(4, Const.NVL((String)(index.sparse ? "Y" : "N"), (String)"N"));
            }
            this.wMongoIndexes.removeEmptyRows();
            this.wMongoIndexes.setRowNums();
            this.wMongoIndexes.optWidth(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCollectionNames(boolean quiet) {
        MongoDbOutputMeta meta = new MongoDbOutputMeta();
        this.getInfo(meta);
        String connectionName = this.variables.resolve(meta.getConnectionName());
        String current = this.wCollectionField.getText();
        this.wCollectionField.removeAll();
        if (!StringUtils.isEmpty((String)connectionName)) {
            try {
                Set<String> collections;
                MongoDbConnection connection = (MongoDbConnection)this.metadataProvider.getSerializer(MongoDbConnection.class).load(connectionName);
                if (connection == null) {
                    throw new HopException("Unable to find MongoDB connection " + connectionName);
                }
                String databaseName = this.variables.resolve(connection.getDbName());
                MongoClientWrapper clientWrapper = connection.createWrapper(this.variables, (ILogChannel)this.log);
                try {
                    collections = clientWrapper.getCollectionsNames(databaseName);
                }
                finally {
                    clientWrapper.dispose();
                }
                for (String c : collections) {
                    this.wCollectionField.add(c);
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)CONST_MONGO_DB_OUTPUT_DIALOG_ERROR_MESSAGE_UNABLE_TO_CONNECT, (String[])new String[0]), e);
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_MONGO_DB_OUTPUT_DIALOG_ERROR_MESSAGE_UNABLE_TO_CONNECT, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_MONGO_DB_OUTPUT_DIALOG_ERROR_MESSAGE_UNABLE_TO_CONNECT, (String[])new String[0]), e);
            }
        } else {
            Object missingConnDetails = "";
            if (StringUtils.isEmpty((String)connectionName)) {
                missingConnDetails = (String)missingConnDetails + "connection name";
            }
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ErrorMessage.MissingConnectionDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ErrorMessage.MissingConnectionDetails", (String[])new String[]{missingConnDetails}));
            smd.open();
        }
        if (!StringUtils.isEmpty((String)current)) {
            this.wCollectionField.setText(current);
        }
    }

    private void getFields() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wMongoFields, (int)1, (int[])new int[]{1}, null, (int)-1, (int)-1, null);
            }
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), e);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private static void pad(StringBuffer toPad, int numBlanks) {
        for (int i = 0; i < numBlanks; ++i) {
            toPad.append(' ');
        }
    }

    public static String prettyPrintDocStructure(String toFormat) {
        StringBuffer result = new StringBuffer();
        int indent = 0;
        String source = toFormat.replaceAll("[ ]*,", ",");
        Element next = Element.OPEN_BRACE;
        while (source.length() > 0) {
            source = source.trim();
            String toIndent = "";
            int minIndex = Integer.MAX_VALUE;
            char targetChar = '{';
            if (source.indexOf(123) > -1 && source.indexOf(123) < minIndex) {
                next = Element.OPEN_BRACE;
                minIndex = source.indexOf(123);
                targetChar = '{';
            }
            if (source.indexOf(125) > -1 && source.indexOf(125) < minIndex) {
                next = Element.CLOSE_BRACE;
                minIndex = source.indexOf(125);
                targetChar = '}';
            }
            if (source.indexOf(91) > -1 && source.indexOf(91) < minIndex) {
                next = Element.OPEN_BRACKET;
                minIndex = source.indexOf(91);
                targetChar = '[';
            }
            if (source.indexOf(93) > -1 && source.indexOf(93) < minIndex) {
                next = Element.CLOSE_BRACKET;
                minIndex = source.indexOf(93);
                targetChar = ']';
            }
            if (source.indexOf(44) > -1 && source.indexOf(44) < minIndex) {
                next = Element.COMMA;
                minIndex = source.indexOf(44);
                targetChar = ',';
            }
            if (minIndex == 0) {
                if (next == Element.CLOSE_BRACE || next == Element.CLOSE_BRACKET) {
                    indent -= 2;
                }
                MongoDbOutputDialog.pad(result, indent);
                String comma = "";
                int offset = 1;
                if (source.length() >= 2 && source.charAt(1) == ',') {
                    comma = ",";
                    offset = 2;
                }
                result.append(targetChar).append(comma).append("\n");
                source = source.substring(offset, source.length());
            } else {
                MongoDbOutputDialog.pad(result, indent);
                if (next == Element.CLOSE_BRACE || next == Element.CLOSE_BRACKET) {
                    toIndent = source.substring(0, minIndex);
                    source = source.substring(minIndex, source.length());
                } else {
                    toIndent = source.substring(0, minIndex + 1);
                    source = source.substring(minIndex + 1, source.length());
                }
                result.append(toIndent.trim()).append("\n");
            }
            if (next != Element.OPEN_BRACE && next != Element.OPEN_BRACKET) continue;
            indent += 2;
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void previewDocStruct() {
        List<MongoDbOutputMeta.MongoField> mongoFields = this.tableToMongoFieldList();
        if (mongoFields == null || mongoFields.isEmpty()) {
            return;
        }
        IRowMeta actualR = null;
        boolean gotGenuineRowMeta = false;
        try {
            actualR = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            gotGenuineRowMeta = true;
        }
        catch (HopException hopException) {
            // empty catch block
        }
        RowMeta r = new RowMeta();
        Object[] dummyRow = new Object[mongoFields.size()];
        int i = 0;
        try {
            void var10_17;
            Variables vs = new Variables();
            vs.initializeFrom(this.variables);
            boolean hasTopLevelJSONDocInsert = MongoDbOutputData.scanForInsertTopLevelJSONDoc(mongoFields);
            for (MongoDbOutputMeta.MongoField mongoField : mongoFields) {
                mongoField.init((IVariables)vs);
                IValueMeta vm = ValueMetaFactory.createValueMeta((int)2);
                vm.setName(mongoField.environUpdatedFieldName);
                r.addValueMeta(vm);
                String val = "";
                if (gotGenuineRowMeta && actualR.indexOfValue(mongoField.environUpdatedFieldName) >= 0) {
                    int index = actualR.indexOfValue(mongoField.environUpdatedFieldName);
                    switch (actualR.getValueMeta(index).getType()) {
                        case 2: {
                            if (mongoField.inputJson) {
                                if (!mongoField.useIncomingFieldNameAsMongoFieldName && StringUtils.isEmpty((String)mongoField.environUpdateMongoDocPath)) {
                                    val = "{\"IncomingJSONDoc\" : \"<document content>\"}";
                                    break;
                                }
                                val = "<JSON sub document>";
                                mongoField.inputJson = false;
                                break;
                            }
                            val = "<string val>";
                            break;
                        }
                        case 5: {
                            val = "<integer val>";
                            break;
                        }
                        case 1: {
                            val = "<number val>";
                            break;
                        }
                        case 4: {
                            val = "<bool val>";
                            break;
                        }
                        case 3: {
                            val = "<date val>";
                            break;
                        }
                        case 8: {
                            val = "<binary val>";
                            break;
                        }
                        default: {
                            val = "<unsupported value type>";
                            break;
                        }
                    }
                } else {
                    val = "<value>";
                }
                dummyRow[i++] = val;
            }
            MongoDbOutputData.MongoTopLevel topLevelStruct = MongoDbOutputData.checkTopLevelConsistency(mongoFields, (IVariables)vs);
            for (MongoDbOutputMeta.MongoField m : mongoFields) {
                m.modifierOperationApplyPolicy = "Insert&Update";
            }
            String string = "";
            String windowTitle = BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.PreviewDocStructure.Title", (String[])new String[0]);
            if (!this.wbModifierUpdate.getSelection()) {
                DBObject result = MongoDbOutputData.hopRowToMongo(mongoFields, (IRowMeta)r, dummyRow, topLevelStruct, hasTopLevelJSONDocInsert);
                String string2 = MongoDbOutputDialog.prettyPrintDocStructure(result.toString());
            } else {
                DBObject query = MongoDbOutputData.getQueryObject(mongoFields, (IRowMeta)r, dummyRow, (IVariables)vs, topLevelStruct);
                DBObject modifier = new MongoDbOutputData().getModifierUpdateObject(mongoFields, (IRowMeta)r, dummyRow, (IVariables)vs, topLevelStruct);
                String string3 = BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.PreviewModifierUpdate.Heading1", (String[])new String[0]) + CONST_NEWLING + MongoDbOutputDialog.prettyPrintDocStructure(query.toString()) + BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.PreviewModifierUpdate.Heading2", (String[])new String[0]) + CONST_NEWLING + MongoDbOutputDialog.prettyPrintDocStructure(modifier.toString());
                windowTitle = BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.PreviewModifierUpdate.Title", (String[])new String[0]);
            }
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 34, windowTitle, (String)var10_17, true);
            smd.open();
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ErrorMessage.ProblemPreviewingDocStructure.Message", (String[])new String[0]) + CONST_NEWLING + ex.getMessage(), ex);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ErrorMessage.ProblemPreviewingDocStructure.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ErrorMessage.ProblemPreviewingDocStructure.Message", (String[])new String[0]) + CONST_NEWLING + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showIndexInfo() {
        String connectionName = this.variables.resolve(this.wConnection.getText());
        if (!StringUtils.isEmpty((String)connectionName)) {
            Object conn = null;
            try {
                MongoDbOutputMeta meta = new MongoDbOutputMeta();
                this.getInfo(meta);
                MongoDbConnection connection = (MongoDbConnection)this.metadataProvider.getSerializer(MongoDbConnection.class).load(connectionName);
                if (connection == null) {
                    throw new HopException("Unable to find MongoDB connection " + connectionName);
                }
                String databaseName = this.variables.resolve(connection.getDbName());
                String collectionName = this.variables.resolve(meta.getCollection());
                MongoClientWrapper wrapper = connection.createWrapper(this.variables, (ILogChannel)this.log);
                StringBuffer result = new StringBuffer();
                for (String index : wrapper.getIndexInfo(databaseName, collectionName)) {
                    result.append(index).append("\n\n");
                }
                ShowMessageDialog smd = new ShowMessageDialog(this.shell, 34, BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.IndexInfo", (String[])new String[]{collectionName}), result.toString(), true);
                smd.open();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ErrorMessage.GeneralError.Message", (String[])new String[0]) + CONST_NEWLING + e.getMessage(), e);
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ErrorMessage.IndexPreview.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbOutputDialog.ErrorMessage.GeneralError.Message", (String[])new String[0]) + CONST_NEWLING + e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
        }
    }

    private static enum Element {
        OPEN_BRACE,
        CLOSE_BRACE,
        OPEN_BRACKET,
        CLOSE_BRACKET,
        COMMA;

    }
}

