/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs;

import com.google.auth.oauth2.GoogleCredentials;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.hop.vfs.gs.GoogleStorageFileSystem;

public class GoogleStorageFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String GOOGLE_CREDENTIALS = "googleCredentials";
    private static final GoogleStorageFileSystemConfigBuilder builder = new GoogleStorageFileSystemConfigBuilder();

    public static GoogleStorageFileSystemConfigBuilder getInstance() {
        return builder;
    }

    private GoogleStorageFileSystemConfigBuilder() {
    }

    public void setGoogleCredentials(FileSystemOptions opts, GoogleCredentials credentials) {
        this.setParam(opts, GOOGLE_CREDENTIALS, credentials);
    }

    public GoogleCredentials getGoogleCredentials(FileSystemOptions opts) {
        return (GoogleCredentials)this.getParam(opts, GOOGLE_CREDENTIALS);
    }

    public void setSchema(FileSystemOptions opts, String schema) {
        this.setParam(opts, "Schema", schema);
    }

    public String getSchema(FileSystemOptions opts) {
        return (String)this.getParam(opts, "Schema");
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return GoogleStorageFileSystem.class;
    }
}

