/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.deletefile;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.FileExistsValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;

@Action(id="DELETE_FILE", name="i18n::ActionDeleteFile.Name", description="i18n::ActionDeleteFile.Description", image="DeleteFile.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionDeleteFile.keyword"}, documentationUrl="/workflow/actions/deletefile.html")
public class ActionDeleteFile
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionDeleteFile.class;
    @HopMetadataProperty(key="filename")
    private String filename;
    @HopMetadataProperty(key="fail_if_file_not_exists")
    private boolean failIfFileNotExists;

    public ActionDeleteFile(String n) {
        super(n, "");
        this.filename = null;
        this.failIfFileNotExists = false;
    }

    public ActionDeleteFile() {
        this("");
    }

    public ActionDeleteFile(ActionDeleteFile meta) {
        super(meta.getName(), meta.getDescription(), meta.getPluginId());
        this.filename = meta.filename;
        this.failIfFileNotExists = meta.failIfFileNotExists;
    }

    public Object clone() {
        return new ActionDeleteFile(this);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (this.filename != null) {
            String realFilename = this.getRealFilename();
            FileObject fileObject = null;
            try {
                fileObject = HopVfs.getFileObject((String)realFilename, (IVariables)this.getVariables());
                if (!fileObject.exists()) {
                    if (this.isFailIfFileNotExists()) {
                        result.setResult(false);
                        this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFile.ERROR_0004_File_Does_Not_Exist", (String[])new String[]{realFilename}));
                        return result;
                    }
                    result.setResult(true);
                    if (!this.isBasic()) return result;
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionDeleteFile.File_Already_Deleted", (String[])new String[]{realFilename}));
                    return result;
                }
                boolean deleted = fileObject.delete();
                if (!deleted) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFile.ERROR_0005_Could_Not_Delete_File", (String[])new String[]{realFilename}));
                    result.setResult(false);
                    result.setNrErrors(1L);
                }
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionDeleteFile.File_Deleted", (String[])new String[]{realFilename}));
                }
                result.setResult(true);
                return result;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFile.ERROR_0006_Exception_Deleting_File", (String[])new String[]{realFilename, e.getMessage()}), e);
                result.setResult(false);
                result.setNrErrors(1L);
                return result;
            }
            finally {
                if (fileObject != null) {
                    try {
                        fileObject.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFile.ERROR_0007_No_Filename_Is_Defined", (String[])new String[0]));
        return result;
    }

    public boolean isFailIfFileNotExists() {
        return this.failIfFileNotExists;
    }

    public void setFailIfFileNotExists(boolean failIfFileExists) {
        this.failIfFileNotExists = failIfFileExists;
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            String realFileName = this.resolve(this.filename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        if (this.isFailIfFileNotExists()) {
            FileExistsValidator.putFailIfDoesNotExist((ValidatorContext)ctx, (boolean)true);
        }
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, ctx);
    }
}

