/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceupsert;

import com.google.common.annotations.VisibleForTesting;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransform;
import org.apache.hop.pipeline.transforms.salesforceupsert.SalesforceUpsertData;
import org.apache.hop.pipeline.transforms.salesforceupsert.SalesforceUpsertMeta;
import org.apache.hop.pipeline.transforms.salesforceutils.SalesforceUtils;

public class SalesforceUpsert
extends SalesforceTransform<SalesforceUpsertMeta, SalesforceUpsertData> {
    private static final Class<?> PKG = SalesforceUpsertMeta.class;
    private static final String BOOLEAN = "boolean";
    private static final String STRING = "string";
    private static final String INT = "int";

    public SalesforceUpsert(TransformMeta transformMeta, SalesforceUpsertMeta meta, SalesforceUpsertData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, meta, data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] outputRowData = this.getRow();
        if (outputRowData == null) {
            if (((SalesforceUpsertData)this.data).iBufferPos > 0) {
                this.flushBuffers();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((SalesforceUpsertData)this.data).sfBuffer = new SObject[((SalesforceUpsertMeta)this.meta).getBatchSizeInt()];
            ((SalesforceUpsertData)this.data).outputBuffer = new Object[((SalesforceUpsertMeta)this.meta).getBatchSizeInt()][];
            ((SalesforceUpsertData)this.data).nrFields = ((SalesforceUpsertMeta)this.meta).getUpdateLookup().length;
            if (((SalesforceUpsertData)this.data).nrFields == 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
            }
            ((SalesforceUpsertData)this.data).inputRowMeta = this.getInputRowMeta().clone();
            ((SalesforceUpsertData)this.data).outputRowMeta = ((SalesforceUpsertData)this.data).inputRowMeta.clone();
            ((SalesforceUpsertMeta)this.meta).getFields(((SalesforceUpsertData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((SalesforceUpsertData)this.data).fieldnrs = new int[((SalesforceUpsertMeta)this.meta).getUpdateStream().length];
            for (int i = 0; i < ((SalesforceUpsertMeta)this.meta).getUpdateStream().length; ++i) {
                ((SalesforceUpsertData)this.data).fieldnrs[i] = this.getInputRowMeta().indexOfValue(((SalesforceUpsertMeta)this.meta).getUpdateStream()[i]);
                if (((SalesforceUpsertData)this.data).fieldnrs[i] >= 0) continue;
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.FieldNotFound", (String[])new String[]{((SalesforceUpsertMeta)this.meta).getUpdateStream()[i]}));
            }
        }
        try {
            this.writeToSalesForce(outputRowData);
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.log.Exception", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    @VisibleForTesting
    void writeToSalesForce(Object[] rowData) throws HopException {
        try {
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.CalledWrite", (Object[])new Object[]{((SalesforceUpsertData)this.data).iBufferPos, ((SalesforceUpsertMeta)this.meta).getBatchSizeInt()}));
            }
            if (((SalesforceUpsertData)this.data).iBufferPos < ((SalesforceUpsertMeta)this.meta).getBatchSizeInt()) {
                ArrayList<String> fieldsToNull = new ArrayList<String>();
                ArrayList<XmlObject> upsertfields = new ArrayList<XmlObject>();
                for (int i = 0; i < ((SalesforceUpsertData)this.data).nrFields; ++i) {
                    IValueMeta valueMeta = ((SalesforceUpsertData)this.data).inputRowMeta.getValueMeta(((SalesforceUpsertData)this.data).fieldnrs[i]);
                    Object object = rowData[((SalesforceUpsertData)this.data).fieldnrs[i]];
                    if (((SalesforceUpsertMeta)this.meta).getUpsertField() != null && valueMeta.isNull(object) && ((SalesforceUpsertMeta)this.meta).getUpsertField().equals(((SalesforceUpsertMeta)this.meta).getUpdateLookup()[i])) continue;
                    if (valueMeta.isNull(object)) {
                        fieldsToNull.add(SalesforceUtils.getFieldToNullName(this.getLogChannel(), ((SalesforceUpsertMeta)this.meta).getUpdateLookup()[i], ((SalesforceUpsertMeta)this.meta).getUseExternalId()[i]));
                        continue;
                    }
                    Object normalObject = this.normalizeValue(valueMeta, rowData[((SalesforceUpsertData)this.data).fieldnrs[i]]);
                    if (((SalesforceUpsertData)this.data).mapData && ((SalesforceUpsertData)this.data).dataTypeMap != null) {
                        normalObject = this.mapDataTypes(valueMeta.getType(), ((SalesforceUpsertMeta)this.meta).getUpdateLookup()[i], normalObject);
                    }
                    upsertfields.add(SalesforceConnection.createMessageElement(((SalesforceUpsertMeta)this.meta).getUpdateLookup()[i], normalObject, ((SalesforceUpsertMeta)this.meta).getUseExternalId()[i]));
                }
                SObject sobjPass = new SObject();
                sobjPass.setType(((SalesforceUpsertData)this.data).connection.getModule());
                if (!upsertfields.isEmpty()) {
                    for (XmlObject element : upsertfields) {
                        this.setFieldInSObject(sobjPass, element);
                    }
                }
                if (!fieldsToNull.isEmpty()) {
                    sobjPass.setFieldsToNull(fieldsToNull.toArray(new String[fieldsToNull.size()]));
                }
                ((SalesforceUpsertData)this.data).sfBuffer[((SalesforceUpsertData)this.data).iBufferPos] = sobjPass;
                ((SalesforceUpsertData)this.data).outputBuffer[((SalesforceUpsertData)this.data).iBufferPos] = rowData;
                ++((SalesforceUpsertData)this.data).iBufferPos;
            }
            if (((SalesforceUpsertData)this.data).iBufferPos >= ((SalesforceUpsertMeta)this.meta).getBatchSizeInt()) {
                if (this.isDetailed()) {
                    this.logDetailed("Calling flush buffer from writeToSalesForce");
                }
                this.flushBuffers();
            }
        }
        catch (HopException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.FailedInWrite", (String[])new String[]{e.toString()}));
        }
    }

    void setFieldInSObject(SObject sobjPass, XmlObject element) {
        Iterator children = element.getChildren();
        String name = element.getName().getLocalPart();
        if (!children.hasNext()) {
            sobjPass.setSObjectField(name, element.getValue());
        } else {
            SObject child = new SObject();
            child.setName(new QName(name));
            while (children.hasNext()) {
                this.setFieldInSObject(child, (XmlObject)children.next());
            }
            sobjPass.setSObjectField(name, (Object)child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffers() throws HopException {
        try {
            if (((SalesforceUpsertData)this.data).sfBuffer.length > ((SalesforceUpsertData)this.data).iBufferPos) {
                SObject[] smallBuffer = new SObject[((SalesforceUpsertData)this.data).iBufferPos];
                System.arraycopy(((SalesforceUpsertData)this.data).sfBuffer, 0, smallBuffer, 0, ((SalesforceUpsertData)this.data).iBufferPos);
                ((SalesforceUpsertData)this.data).sfBuffer = smallBuffer;
            }
            ((SalesforceUpsertData)this.data).upsertResult = ((SalesforceUpsertData)this.data).connection.upsert(((SalesforceUpsertMeta)this.meta).getUpsertField(), ((SalesforceUpsertData)this.data).sfBuffer);
            int nr = ((SalesforceUpsertData)this.data).upsertResult.length;
            for (int j = 0; j < nr; ++j) {
                if (((SalesforceUpsertData)this.data).upsertResult[j].isSuccess()) {
                    String id = ((SalesforceUpsertData)this.data).upsertResult[j].getId();
                    if (((SalesforceUpsertData)this.data).upsertResult[j].isCreated()) {
                        this.incrementLinesOutput();
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.ObjectCreated", (String[])new String[]{id}));
                        }
                    } else {
                        this.incrementLinesUpdated();
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.ObjectUpdated", (String[])new String[]{id}));
                        }
                    }
                    Object[] newRow = RowDataUtil.resizeArray((Object[])((SalesforceUpsertData)this.data).outputBuffer[j], (int)((SalesforceUpsertData)this.data).outputRowMeta.size());
                    if (((SalesforceUpsertData)this.data).realSalesforceFieldName != null) {
                        int newIndex = ((SalesforceUpsertData)this.data).inputRowMeta.size();
                        newRow[newIndex++] = id;
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.NewRow", (Object[])new Object[]{newRow[0]}));
                    }
                    this.putRow(((SalesforceUpsertData)this.data).outputRowMeta, newRow);
                    if (!this.checkFeedback(this.getLinesInput()) || !this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.log.LineRow", (String[])new String[]{"" + this.getLinesInput()}));
                    continue;
                }
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.ErrorFound", (String[])new String[0]));
                    }
                    Error err = ((SalesforceUpsertData)this.data).upsertResult[j].getErrors()[0];
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.Error.FlushBuffer", (Object[])new Object[]{j, err.getStatusCode(), err.getMessage()}));
                }
                StringBuilder errorMessage = new StringBuilder();
                for (int i = 0; i < ((SalesforceUpsertData)this.data).upsertResult[j].getErrors().length; ++i) {
                    Error err = ((SalesforceUpsertData)this.data).upsertResult[j].getErrors()[i];
                    errorMessage.append(BaseMessages.getString(PKG, (String)"SalesforceUpsert.Error.FlushBuffer", (Object[])new Object[]{j, err.getStatusCode(), err.getMessage()}));
                }
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceUpsert.PassingRowToErrorTransform", (String[])new String[0]));
                }
                this.putError(this.getInputRowMeta(), ((SalesforceUpsertData)this.data).outputBuffer[j], 1L, errorMessage.toString(), null, "SalesforceUpsert001");
            }
            ((SalesforceUpsertData)this.data).sfBuffer = new SObject[((SalesforceUpsertMeta)this.meta).getBatchSizeInt()];
            ((SalesforceUpsertData)this.data).outputBuffer = new Object[((SalesforceUpsertMeta)this.meta).getBatchSizeInt()][];
            ((SalesforceUpsertData)this.data).iBufferPos = 0;
        }
        catch (Exception e) {
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                if (e instanceof HopException) {
                    HopException hopException = (HopException)((Object)e);
                    throw hopException;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.FailedUpsert", (String[])new String[]{e.getMessage()}), (Throwable)e);
            }
            if (this.isDebug()) {
                this.logDebug("Passing row to error transform");
            }
            for (int i = 0; i < ((SalesforceUpsertData)this.data).iBufferPos; ++i) {
                this.putError(((SalesforceUpsertData)this.data).inputRowMeta, ((SalesforceUpsertData)this.data).outputBuffer[i], 1L, e.getMessage(), null, "SalesforceUpsert002");
            }
        }
        finally {
            if (((SalesforceUpsertData)this.data).upsertResult != null) {
                ((SalesforceUpsertData)this.data).upsertResult = null;
            }
        }
    }

    @Override
    public boolean init() {
        ((SalesforceUpsertData)this.data).mapData = "true".equalsIgnoreCase(System.getProperties().getProperty("MAP_SALESFORCE_UPSERT_DATA_TYPES"));
        if (super.init()) {
            try {
                Field[] fields;
                String salesfoceIdFieldname = this.resolve(((SalesforceUpsertMeta)this.meta).getSalesforceIDFieldName());
                if (!Utils.isEmpty((CharSequence)salesfoceIdFieldname)) {
                    ((SalesforceUpsertData)this.data).realSalesforceFieldName = salesfoceIdFieldname;
                }
                ((SalesforceUpsertData)this.data).connection.setRollbackAllChangesOnError(((SalesforceUpsertMeta)this.meta).isRollbackAllChangesOnError());
                ((SalesforceUpsertData)this.data).connection.connect();
                if (((SalesforceUpsertData)this.data).mapData && (fields = ((SalesforceUpsertData)this.data).connection.getObjectFields(this.resolve(((SalesforceUpsertMeta)this.meta).getModule()))) != null) {
                    ((SalesforceUpsertData)this.data).dataTypeMap = this.mapDataTypesToFields(fields);
                }
                return true;
            }
            catch (HopException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceUpsert.Log.ErrorOccurredDuringTransformInitialize", (String[])new String[0]) + ke.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        if (((SalesforceUpsertData)this.data).outputBuffer != null) {
            ((SalesforceUpsertData)this.data).outputBuffer = null;
        }
        if (((SalesforceUpsertData)this.data).sfBuffer != null) {
            ((SalesforceUpsertData)this.data).sfBuffer = null;
        }
        super.dispose();
    }

    private Map<String, String> mapDataTypesToFields(Field[] fields) {
        HashMap<String, String> mappedFields = new HashMap<String, String>();
        for (Field f : fields) {
            String fieldType = f.getType().toString();
            if ("base64".equalsIgnoreCase(fieldType) || "date".equalsIgnoreCase(fieldType) || "datetime".equalsIgnoreCase(fieldType) || INT.equalsIgnoreCase(fieldType) || "double".equalsIgnoreCase(fieldType) || BOOLEAN.equalsIgnoreCase(fieldType)) {
                mappedFields.put(f.getName(), fieldType);
                continue;
            }
            mappedFields.put(f.getName(), STRING);
        }
        return mappedFields;
    }

    private Object mapDataTypes(int type, String name, Object value) {
        try {
            switch (type) {
                case 5: {
                    if (STRING.equalsIgnoreCase(((SalesforceUpsertData)this.data).dataTypeMap.get(name))) {
                        value = String.valueOf(value);
                        break;
                    }
                    if (!BOOLEAN.equalsIgnoreCase(((SalesforceUpsertData)this.data).dataTypeMap.get(name))) break;
                    int i = (Integer)value;
                    if (i == 0 || i == 1) {
                        value = i == 1;
                    }
                    break;
                }
                case 4: {
                    if (!STRING.equalsIgnoreCase(((SalesforceUpsertData)this.data).dataTypeMap.get(name))) break;
                    value = String.valueOf(value);
                    break;
                }
                case 1: {
                    if (STRING.equalsIgnoreCase(((SalesforceUpsertData)this.data).dataTypeMap.get(name))) {
                        value = String.valueOf(value);
                        break;
                    }
                    if (!BOOLEAN.equalsIgnoreCase(((SalesforceUpsertData)this.data).dataTypeMap.get(name))) break;
                    Double d = (Double)value;
                    if (0.0 <= d && d < 2.0) {
                        value = d.intValue() == 1;
                    }
                    break;
                }
                case 2: {
                    if (INT.equalsIgnoreCase(((SalesforceUpsertData)this.data).dataTypeMap.get(name))) {
                        value = Integer.valueOf((String)value);
                        break;
                    }
                    if (!BOOLEAN.equalsIgnoreCase(((SalesforceUpsertData)this.data).dataTypeMap.get(name))) break;
                    if ("true".equalsIgnoreCase((String)value) || "false".equalsIgnoreCase((String)value)) {
                        value = Boolean.valueOf((String)value);
                        break;
                    }
                    if (((String)value).startsWith("-")) break;
                    Double d = Double.parseDouble((String)value);
                    if (0.0 <= d && d < 2.0) {
                        value = d.intValue() == 1;
                    }
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

