/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Comparators;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface StreamingOptions
extends ApplicationNameOptions,
PipelineOptions {
    @Description(value="Set to true if running a streaming pipeline. This will be automatically set to true if the pipeline contains an Unbounded PCollection.")
    @Hidden
    public @UnknownKeyFor @NonNull @Initialized boolean isStreaming();

    public void setStreaming(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="If set, attempts to produce a pipeline compatible with this prior version of the Beam SDK. This string should be interpreted and compared per https://semver.org/. See, for example, https://cloud.google.com/dataflow/docs/guides/updating-a-pipeline.")
    public @Nullable @UnknownKeyFor @Initialized String getUpdateCompatibilityVersion();

    public void setUpdateCompatibilityVersion(@Nullable @UnknownKeyFor @Initialized String var1);

    public static @UnknownKeyFor @NonNull @Initialized boolean updateCompatibilityVersionLessThan(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized String version) {
        if (options == null) {
            return false;
        }
        String updateCompatibilityVersion = options.as(StreamingOptions.class).getUpdateCompatibilityVersion();
        if (updateCompatibilityVersion == null) {
            return false;
        }
        List<String> requestedVersion = Arrays.asList(updateCompatibilityVersion.split("\\."));
        List<String> targetVersion = Arrays.asList(version.split("\\."));
        return Comparators.lexicographical(Comparator.naturalOrder()).compare(requestedVersion, targetVersion) < 0;
    }
}

