/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SourceReaderFactory;
import org.apache.flink.api.connector.source.lib.NumberSequenceSource;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimitedSourceReader;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiter;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiterStrategy;
import org.apache.flink.connector.datagen.source.GeneratingIteratorSourceReader;
import org.apache.flink.connector.datagen.source.GeneratorFunction;
import org.apache.flink.util.Preconditions;

@Internal
class GeneratorSourceReaderFactory<OUT>
implements SourceReaderFactory<OUT, NumberSequenceSource.NumberSequenceSplit> {
    private final GeneratorFunction<Long, OUT> generatorFunction;
    private final RateLimiterStrategy rateLimiterStrategy;

    public GeneratorSourceReaderFactory(GeneratorFunction<Long, OUT> generatorFunction, RateLimiterStrategy rateLimiterStrategy) {
        this.generatorFunction = (GeneratorFunction)Preconditions.checkNotNull(generatorFunction);
        this.rateLimiterStrategy = (RateLimiterStrategy)Preconditions.checkNotNull((Object)rateLimiterStrategy);
    }

    public SourceReader<OUT, NumberSequenceSource.NumberSequenceSplit> createReader(SourceReaderContext readerContext) {
        int parallelism = readerContext.currentParallelism();
        RateLimiter rateLimiter = this.rateLimiterStrategy.createRateLimiter(parallelism);
        return new RateLimitedSourceReader(new GeneratingIteratorSourceReader(readerContext, this.generatorFunction), rateLimiter);
    }
}

