/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.AccumulateImportDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.EntryPointDeclarationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.kie.api.io.Resource;
import org.kie.internal.builder.ResourceChange;

public class CompositePackageDescr
extends PackageDescr {
    private CompositeAssetFilter filter;

    public CompositePackageDescr() {
    }

    public CompositePackageDescr(Resource resource, PackageDescr packageDescr) {
        super(packageDescr.getNamespace(), packageDescr.getDocumentation());
        this.internalAdd(resource, packageDescr);
    }

    public void addPackageDescr(Resource resource, PackageDescr packageDescr) {
        if (!this.getNamespace().equals(packageDescr.getNamespace())) {
            throw new RuntimeException("Composing PackageDescr (" + packageDescr.getName() + ") in different namespaces (namespace=" + this.getNamespace() + " packageDescr=" + packageDescr.getNamespace() + ")");
        }
        this.internalAdd(resource, packageDescr);
    }

    private void internalAdd(Resource resource, PackageDescr packageDescr) {
        for (ImportDescr importDescr : packageDescr.getImports()) {
            this.addImport(importDescr);
            importDescr.setResource(resource);
        }
        for (FunctionImportDescr functionImportDescr : packageDescr.getFunctionImports()) {
            this.addFunctionImport(functionImportDescr);
            functionImportDescr.setResource(resource);
        }
        for (AccumulateImportDescr accumulateImportDescr : packageDescr.getAccumulateImports()) {
            this.addAccumulateImport(accumulateImportDescr);
            accumulateImportDescr.setResource(resource);
        }
        for (AttributeDescr attributeDescr : packageDescr.getAttributes()) {
            this.addAttribute(attributeDescr);
            attributeDescr.setResource(resource);
        }
        for (GlobalDescr globalDescr : packageDescr.getGlobals()) {
            this.addGlobal(globalDescr);
            globalDescr.setResource(resource);
        }
        for (FunctionDescr functionDescr : packageDescr.getFunctions()) {
            this.addFunction(functionDescr);
            functionDescr.setResource(resource);
        }
        for (RuleDescr ruleDescr : packageDescr.getRules()) {
            this.addRule(ruleDescr);
            ruleDescr.setResource(resource);
        }
        HashSet<TypeDeclarationDescr> typeDeclarationDescrs = new HashSet<TypeDeclarationDescr>(this.getTypeDeclarations());
        for (TypeDeclarationDescr typeDeclarationDescr : packageDescr.getTypeDeclarations()) {
            if (typeDeclarationDescrs.contains(typeDeclarationDescr)) continue;
            this.addTypeDeclaration(typeDeclarationDescr);
            typeDeclarationDescr.setResource(resource);
        }
        for (EnumDeclarationDescr enumDeclarationDescr : packageDescr.getEnumDeclarations()) {
            this.addEnumDeclaration(enumDeclarationDescr);
            enumDeclarationDescr.setResource(resource);
        }
        for (EntryPointDeclarationDescr entryPointDeclarationDescr : packageDescr.getEntryPointDeclarations()) {
            this.addEntryPointDeclaration(entryPointDeclarationDescr);
            entryPointDeclarationDescr.setResource(resource);
        }
        for (WindowDeclarationDescr windowDeclarationDescr : packageDescr.getWindowDeclarations()) {
            this.addWindowDeclaration(windowDeclarationDescr);
            windowDeclarationDescr.setResource(resource);
        }
        packageDescr.getPreferredPkgUUID().ifPresent(pkgUUID -> {
            if (this.getPreferredPkgUUID().isPresent() && !pkgUUID.equals(this.getPreferredPkgUUID().get())) {
                throw new RuntimeException(String.format("Trying to overwrite preferredPkgUUID %s with a different value %s", this.getPreferredPkgUUID().get(), pkgUUID));
            }
            this.setPreferredPkgUUID((String)pkgUUID);
        });
    }

    public CompositeAssetFilter getFilter() {
        return this.filter;
    }

    public void addFilter(KnowledgeBuilderImpl.AssetFilter f) {
        if (f != null) {
            if (this.filter == null) {
                this.filter = new CompositeAssetFilter();
            }
            this.filter.filters.add(f);
        }
    }

    public static class CompositeAssetFilter
    implements KnowledgeBuilderImpl.AssetFilter {
        public List<KnowledgeBuilderImpl.AssetFilter> filters = new ArrayList<KnowledgeBuilderImpl.AssetFilter>();

        @Override
        public KnowledgeBuilderImpl.AssetFilter.Action accept(ResourceChange.Type type, String pkgName, String assetName) {
            for (KnowledgeBuilderImpl.AssetFilter filter : this.filters) {
                KnowledgeBuilderImpl.AssetFilter.Action result = filter.accept(type, pkgName, assetName);
                if (KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING.equals((Object)result)) continue;
                return result;
            }
            return KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING;
        }
    }
}

