/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.sampler.plugins.first;

import java.util.List;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerPlugin;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.plugins.ExecutionDataSamplerBase;
import org.apache.hop.execution.sampler.plugins.first.FirstRowsExecutionDataSamplerStore;
import org.apache.hop.pipeline.transform.stream.IStream;

@GuiPlugin
@ExecutionDataSamplerPlugin(id="FirstRowsExecutionDataSampler", name="First output rows", description="Samples the first rows of a transform output")
public class FirstRowsExecutionDataSampler
extends ExecutionDataSamplerBase<FirstRowsExecutionDataSamplerStore>
implements IExecutionDataSampler<FirstRowsExecutionDataSamplerStore> {
    private static final Class<?> PKG = FirstRowsExecutionDataSampler.class;

    public FirstRowsExecutionDataSampler() {
    }

    public FirstRowsExecutionDataSampler(FirstRowsExecutionDataSampler sampler) {
        super(sampler);
    }

    public FirstRowsExecutionDataSampler(String sampleSize) {
        super(sampleSize, "FirstRowsExecutionDataSampler", "First output rows");
    }

    @Override
    public FirstRowsExecutionDataSampler clone() {
        return new FirstRowsExecutionDataSampler(this);
    }

    @Override
    public FirstRowsExecutionDataSamplerStore createSamplerStore(ExecutionDataSamplerMeta samplerMeta) {
        return new FirstRowsExecutionDataSamplerStore(this, samplerMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sampleRow(FirstRowsExecutionDataSamplerStore samplerStore, IStream.StreamType streamType, IRowMeta rowMeta, Object[] row) throws HopValueException {
        List<Object[]> list = samplerStore.getRows();
        synchronized (list) {
            List<Object[]> rows = samplerStore.getRows();
            if (streamType != IStream.StreamType.OUTPUT || samplerStore.getMaxRows() <= 0 || rows.size() >= samplerStore.getMaxRows()) {
                return;
            }
            if (rows.isEmpty()) {
                samplerStore.setRowMeta(rowMeta);
            }
            rows.add(rowMeta.cloneRow(row));
        }
    }
}

