/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.monetdb.jdbc.MonetWrapper;

public final class MonetClob
implements Clob {
    private StringBuilder buf;

    protected MonetClob(String string) {
        this.buf = new StringBuilder(string);
    }

    private final void checkBufIsNotNull() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This MonetClob has been freed", "M1M20");
        }
    }

    @Override
    public void free() {
        this.buf = null;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkBufIsNotNull();
        return new ByteArrayInputStream(this.buf.toString().getBytes());
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkBufIsNotNull();
        return new StringReader(this.buf.toString());
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new SQLException("Invalid length value: " + l2, "M1M05");
        }
        return new StringReader(this.getSubString(l, (int)l2));
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        this.checkBufIsNotNull();
        if (l == 1L && n == this.buf.length()) {
            return this.buf.toString();
        }
        if (l < 1L || l > (long)this.buf.length()) {
            throw new SQLException("Invalid pos value: " + l, "M1M05");
        }
        if (n < 0 || l - 1L + (long)n > (long)this.buf.length()) {
            throw new SQLException("Invalid length value: " + n, "M1M05");
        }
        try {
            return this.buf.substring((int)(l - 1L), (int)(l - 1L + (long)n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SQLException(indexOutOfBoundsException.getMessage(), "M1M05");
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkBufIsNotNull();
        return this.buf.length();
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        if (clob == null) {
            throw new SQLException("Missing searchstr object", "M1M05");
        }
        return this.position(clob.toString(), l);
    }

    @Override
    public long position(String string, long l) throws SQLException {
        this.checkBufIsNotNull();
        if (string == null) {
            throw new SQLException("Missing searchstr object", "M1M05");
        }
        if (l < 1L || l > (long)this.buf.length()) {
            throw new SQLException("Invalid start value: " + l, "M1M05");
        }
        return this.buf.indexOf(string, (int)(l - 1L));
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        throw MonetWrapper.newSQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        throw MonetWrapper.newSQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        int n = string != null ? string.length() : 0;
        return this.setString(l, string, 0, n);
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.checkBufIsNotNull();
        if (string == null) {
            throw new SQLException("Missing str object", "M1M05");
        }
        if (l < 1L || l > Integer.MAX_VALUE) {
            throw new SQLException("Invalid pos value: " + l, "M1M05");
        }
        if (n < 0 || n > string.length()) {
            throw new SQLException("Invalid offset value: " + n, "M1M05");
        }
        if (n2 < 1 || n + n2 > string.length()) {
            throw new SQLException("Invalid len value: " + n2, "M1M05");
        }
        if ((int)l + n2 > this.buf.capacity()) {
            this.buf.ensureCapacity((int)l + n2);
        }
        this.buf.replace((int)l - 1, (int)l + n2, string.substring(n, n + n2));
        return n2;
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.checkBufIsNotNull();
        if (l < 0L || l > (long)this.buf.length()) {
            throw new SQLException("Invalid len value: " + l, "M1M05");
        }
        this.buf.setLength((int)l);
        this.buf.trimToSize();
    }

    public String toString() {
        if (this.buf == null) {
            return "";
        }
        return this.buf.toString();
    }
}

