/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.BooleanPrimitiveArrayComparator;
import org.apache.flink.api.common.typeutils.base.array.BooleanPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArrayComparator;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.CharPrimitiveArrayComparator;
import org.apache.flink.api.common.typeutils.base.array.CharPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.DoublePrimitiveArrayComparator;
import org.apache.flink.api.common.typeutils.base.array.DoublePrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.FloatPrimitiveArrayComparator;
import org.apache.flink.api.common.typeutils.base.array.FloatPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.IntPrimitiveArrayComparator;
import org.apache.flink.api.common.typeutils.base.array.IntPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.LongPrimitiveArrayComparator;
import org.apache.flink.api.common.typeutils.base.array.LongPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.PrimitiveArrayComparator;
import org.apache.flink.api.common.typeutils.base.array.ShortPrimitiveArrayComparator;
import org.apache.flink.api.common.typeutils.base.array.ShortPrimitiveArraySerializer;
import org.apache.flink.util.Preconditions;

@Public
public class PrimitiveArrayTypeInfo<T>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = 1L;
    public static final PrimitiveArrayTypeInfo<boolean[]> BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO = new PrimitiveArrayTypeInfo<boolean[]>(boolean[].class, BooleanPrimitiveArraySerializer.INSTANCE, BooleanPrimitiveArrayComparator.class);
    public static final PrimitiveArrayTypeInfo<byte[]> BYTE_PRIMITIVE_ARRAY_TYPE_INFO = new PrimitiveArrayTypeInfo<byte[]>(byte[].class, BytePrimitiveArraySerializer.INSTANCE, BytePrimitiveArrayComparator.class);
    public static final PrimitiveArrayTypeInfo<short[]> SHORT_PRIMITIVE_ARRAY_TYPE_INFO = new PrimitiveArrayTypeInfo<short[]>(short[].class, ShortPrimitiveArraySerializer.INSTANCE, ShortPrimitiveArrayComparator.class);
    public static final PrimitiveArrayTypeInfo<int[]> INT_PRIMITIVE_ARRAY_TYPE_INFO = new PrimitiveArrayTypeInfo<int[]>(int[].class, IntPrimitiveArraySerializer.INSTANCE, IntPrimitiveArrayComparator.class);
    public static final PrimitiveArrayTypeInfo<long[]> LONG_PRIMITIVE_ARRAY_TYPE_INFO = new PrimitiveArrayTypeInfo<long[]>(long[].class, LongPrimitiveArraySerializer.INSTANCE, LongPrimitiveArrayComparator.class);
    public static final PrimitiveArrayTypeInfo<float[]> FLOAT_PRIMITIVE_ARRAY_TYPE_INFO = new PrimitiveArrayTypeInfo<float[]>(float[].class, FloatPrimitiveArraySerializer.INSTANCE, FloatPrimitiveArrayComparator.class);
    public static final PrimitiveArrayTypeInfo<double[]> DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO = new PrimitiveArrayTypeInfo<double[]>(double[].class, DoublePrimitiveArraySerializer.INSTANCE, DoublePrimitiveArrayComparator.class);
    public static final PrimitiveArrayTypeInfo<char[]> CHAR_PRIMITIVE_ARRAY_TYPE_INFO = new PrimitiveArrayTypeInfo<char[]>(char[].class, CharPrimitiveArraySerializer.INSTANCE, CharPrimitiveArrayComparator.class);
    private final Class<T> arrayClass;
    private final TypeSerializer<T> serializer;
    private final Class<? extends PrimitiveArrayComparator<T, ?>> comparatorClass;
    private static final Map<Class<?>, PrimitiveArrayTypeInfo<?>> TYPES = new HashMap();

    private PrimitiveArrayTypeInfo(Class<T> arrayClass, TypeSerializer<T> serializer, Class<? extends PrimitiveArrayComparator<T, ?>> comparatorClass) {
        this.arrayClass = Preconditions.checkNotNull(arrayClass);
        this.serializer = Preconditions.checkNotNull(serializer);
        this.comparatorClass = Preconditions.checkNotNull(comparatorClass);
        Preconditions.checkArgument(arrayClass.isArray() && arrayClass.getComponentType().isPrimitive(), "Class must represent an array of primitives");
    }

    @Override
    @PublicEvolving
    public boolean isBasicType() {
        return false;
    }

    @Override
    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @Override
    @PublicEvolving
    public int getArity() {
        return 1;
    }

    @Override
    @PublicEvolving
    public int getTotalFields() {
        return 1;
    }

    @Override
    @PublicEvolving
    public Class<T> getTypeClass() {
        return this.arrayClass;
    }

    @Override
    @PublicEvolving
    public boolean isKeyType() {
        return true;
    }

    @Override
    @PublicEvolving
    public TypeSerializer<T> createSerializer(SerializerConfig serializerConfig) {
        return this.serializer;
    }

    @Override
    @PublicEvolving
    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return this.createSerializer(config.getSerializerConfig());
    }

    @PublicEvolving
    public Class<?> getComponentClass() {
        return this.arrayClass.getComponentType();
    }

    @PublicEvolving
    public TypeInformation<?> getComponentType() {
        return BasicTypeInfo.getInfoFor(this.getComponentClass());
    }

    @Override
    public String toString() {
        return this.arrayClass.getComponentType().getName() + "[]";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof PrimitiveArrayTypeInfo) {
            PrimitiveArrayTypeInfo otherArray = (PrimitiveArrayTypeInfo)other;
            return otherArray.canEqual(this) && this.arrayClass == otherArray.arrayClass && this.serializer.equals(otherArray.serializer) && this.comparatorClass == otherArray.comparatorClass;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arrayClass, this.serializer, this.comparatorClass);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof PrimitiveArrayTypeInfo;
    }

    @PublicEvolving
    public static <X> PrimitiveArrayTypeInfo<X> getInfoFor(Class<X> type) {
        if (!type.isArray()) {
            throw new InvalidTypesException("The given class is no array.");
        }
        return TYPES.get(type);
    }

    @PublicEvolving
    public PrimitiveArrayComparator<T, ?> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        try {
            return this.comparatorClass.getConstructor(Boolean.TYPE).newInstance(sortOrderAscending);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize primitive " + this.comparatorClass.getName() + " array comparator.", e);
        }
    }

    static {
        TYPES.put(boolean[].class, BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO);
        TYPES.put(byte[].class, BYTE_PRIMITIVE_ARRAY_TYPE_INFO);
        TYPES.put(short[].class, SHORT_PRIMITIVE_ARRAY_TYPE_INFO);
        TYPES.put(int[].class, INT_PRIMITIVE_ARRAY_TYPE_INFO);
        TYPES.put(long[].class, LONG_PRIMITIVE_ARRAY_TYPE_INFO);
        TYPES.put(float[].class, FLOAT_PRIMITIVE_ARRAY_TYPE_INFO);
        TYPES.put(double[].class, DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO);
        TYPES.put(char[].class, CHAR_PRIMITIVE_ARRAY_TYPE_INFO);
    }
}

