/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.partition.DeduplicatedQueue;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageInputChannelId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.AvailabilityNotifier;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteStorageScanner;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class RemoteTierConsumerAgent
implements TierConsumerAgent,
AvailabilityNotifier {
    private final List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs;
    private final RemoteStorageScanner remoteStorageScanner;
    private final PartitionFileReader partitionFileReader;
    private final Map<TieredStoragePartitionId, Map<TieredStorageSubpartitionId, Tuple2<Integer, Integer>>> currentBufferIndexAndSegmentIds;
    private final Map<TieredStoragePartitionId, DeduplicatedQueue<TieredStorageSubpartitionId>> availableSubpartitionsQueues = new HashMap<TieredStoragePartitionId, DeduplicatedQueue<TieredStorageSubpartitionId>>();
    private final int bufferSizeBytes;
    private AvailabilityNotifier notifier;

    public RemoteTierConsumerAgent(List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, RemoteStorageScanner remoteStorageScanner, PartitionFileReader partitionFileReader, int bufferSizeBytes) {
        this.tieredStorageConsumerSpecs = tieredStorageConsumerSpecs;
        this.remoteStorageScanner = remoteStorageScanner;
        this.currentBufferIndexAndSegmentIds = new HashMap<TieredStoragePartitionId, Map<TieredStorageSubpartitionId, Tuple2<Integer, Integer>>>();
        this.partitionFileReader = partitionFileReader;
        this.bufferSizeBytes = bufferSizeBytes;
        this.remoteStorageScanner.registerAvailabilityAndPriorityNotifier(this);
        for (TieredStorageConsumerSpec spec : tieredStorageConsumerSpecs) {
            this.availableSubpartitionsQueues.putIfAbsent(spec.getPartitionId(), new DeduplicatedQueue());
        }
    }

    @Override
    public void start() {
        this.remoteStorageScanner.start();
        for (TieredStorageConsumerSpec spec : this.tieredStorageConsumerSpecs) {
            for (int subpartitionId : spec.getSubpartitionIds().values()) {
                this.remoteStorageScanner.watchSegment(spec.getPartitionId(), new TieredStorageSubpartitionId(subpartitionId), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int peekNextBufferSubpartitionId(TieredStoragePartitionId partitionId, ResultSubpartitionIndexSet indexSet) throws IOException {
        Map<TieredStoragePartitionId, DeduplicatedQueue<TieredStorageSubpartitionId>> map = this.availableSubpartitionsQueues;
        synchronized (map) {
            for (TieredStorageSubpartitionId subpartitionId : this.availableSubpartitionsQueues.get(partitionId).values()) {
                if (!indexSet.contains(subpartitionId.getSubpartitionId())) continue;
                return subpartitionId.getSubpartitionId();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Buffer> getNextBuffer(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subpartitionId, int segmentId) {
        Tuple2 bufferIndexAndSegmentId = this.currentBufferIndexAndSegmentIds.computeIfAbsent(partitionId, ignore -> new HashMap()).getOrDefault(subpartitionId, Tuple2.of((Object)0, (Object)0));
        int currentBufferIndex = (Integer)bufferIndexAndSegmentId.f0;
        int currentSegmentId = (Integer)bufferIndexAndSegmentId.f1;
        if (segmentId != currentSegmentId) {
            this.remoteStorageScanner.watchSegment(partitionId, subpartitionId, segmentId);
        }
        MemorySegment memorySegment = MemorySegmentFactory.allocateUnpooledSegment((int)this.bufferSizeBytes);
        PartitionFileReader.ReadBufferResult readBufferResult = null;
        try {
            readBufferResult = this.partitionFileReader.readBuffer(partitionId, subpartitionId, segmentId, currentBufferIndex, memorySegment, FreeingBufferRecycler.INSTANCE, null, null);
        }
        catch (IOException e) {
            memorySegment.free();
            ExceptionUtils.rethrow((Throwable)e, (String)"Failed to read buffer from partition file.");
        }
        if (readBufferResult != null && !readBufferResult.getReadBuffers().isEmpty()) {
            List<Buffer> readBuffers = readBufferResult.getReadBuffers();
            Preconditions.checkState((readBuffers.size() == 1 ? 1 : 0) != 0);
            Buffer buffer = readBuffers.get(0);
            this.currentBufferIndexAndSegmentIds.get(partitionId).put(subpartitionId, (Tuple2<Integer, Integer>)Tuple2.of((Object)(++currentBufferIndex), (Object)segmentId));
            return Optional.of(buffer);
        }
        memorySegment.free();
        Map<TieredStoragePartitionId, DeduplicatedQueue<TieredStorageSubpartitionId>> map = this.availableSubpartitionsQueues;
        synchronized (map) {
            this.availableSubpartitionsQueues.get(partitionId).remove(subpartitionId);
        }
        return Optional.empty();
    }

    @Override
    public void registerAvailabilityNotifier(AvailabilityNotifier notifier) {
        Preconditions.checkState((this.notifier == null ? 1 : 0) != 0);
        this.notifier = notifier;
    }

    @Override
    public void close() throws IOException {
        this.remoteStorageScanner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAvailable(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subpartitionId) {
        Map<TieredStoragePartitionId, DeduplicatedQueue<TieredStorageSubpartitionId>> map = this.availableSubpartitionsQueues;
        synchronized (map) {
            if (!this.availableSubpartitionsQueues.get(partitionId).add(subpartitionId)) {
                return;
            }
        }
        this.notifier.notifyAvailable(partitionId, subpartitionId);
    }

    @Override
    public void notifyAvailable(TieredStoragePartitionId partitionId, TieredStorageInputChannelId inputChannelId) {
        throw new UnsupportedOperationException("This method should not be invoked.");
    }
}

