/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.groups.SinkCommitterMetricGroup;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;

@Internal
public class InternalSinkCommitterMetricGroup
extends ProxyMetricGroup<MetricGroup>
implements SinkCommitterMetricGroup {
    private final Counter numCommittablesTotal;
    private final Counter numCommittablesFailure;
    private final Counter numCommittablesRetry;
    private final Counter numCommitatblesSuccess;
    private final Counter numCommitatblesAlreadyCommitted;
    private final OperatorIOMetricGroup operatorIOMetricGroup;

    @VisibleForTesting
    InternalSinkCommitterMetricGroup(MetricGroup parentMetricGroup, OperatorIOMetricGroup operatorIOMetricGroup) {
        super(parentMetricGroup);
        this.numCommittablesTotal = parentMetricGroup.counter("totalCommittables");
        this.numCommittablesFailure = parentMetricGroup.counter("failedCommittables");
        this.numCommittablesRetry = parentMetricGroup.counter("retriedCommittables");
        this.numCommitatblesSuccess = parentMetricGroup.counter("successfulCommittables");
        this.numCommitatblesAlreadyCommitted = parentMetricGroup.counter("alreadyCommittedCommittables");
        this.operatorIOMetricGroup = operatorIOMetricGroup;
    }

    public static InternalSinkCommitterMetricGroup wrap(OperatorMetricGroup operatorMetricGroup) {
        return new InternalSinkCommitterMetricGroup((MetricGroup)operatorMetricGroup, operatorMetricGroup.getIOMetricGroup());
    }

    public OperatorIOMetricGroup getIOMetricGroup() {
        return this.operatorIOMetricGroup;
    }

    public Counter getNumCommittablesTotalCounter() {
        return this.numCommittablesTotal;
    }

    public Counter getNumCommittablesFailureCounter() {
        return this.numCommittablesFailure;
    }

    public Counter getNumCommittablesRetryCounter() {
        return this.numCommittablesRetry;
    }

    public Counter getNumCommittablesSuccessCounter() {
        return this.numCommitatblesSuccess;
    }

    public Counter getNumCommittablesAlreadyCommittedCounter() {
        return this.numCommitatblesAlreadyCommitted;
    }

    public void setCurrentPendingCommittablesGauge(Gauge<Integer> currentPendingCommittablesGauge) {
        this.parentMetricGroup.gauge("pendingCommittables", currentPendingCommittablesGauge);
    }
}

