/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.accessoutput;

import io.github.spannm.jackcess.Database;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;

public enum AccessFileFormat implements IEnumHasCodeAndDescription
{
    V2003(Database.FileFormat.V2003, "MS Access 2002/2003"),
    V2007(Database.FileFormat.V2007, "MS Access 2007"),
    V2010(Database.FileFormat.V2010, "MS Access 2010+"),
    V2016(Database.FileFormat.V2016, "MS Access 2016+"),
    V2019(Database.FileFormat.V2019, "MS Access 2019+ (Office 365)");

    private final Database.FileFormat format;
    private final String code;
    private final String description;

    private AccessFileFormat(Database.FileFormat format, String description) {
        this.format = format;
        this.code = format.name();
        this.description = description;
    }

    public static String[] getDescriptions() {
        return IEnumHasCodeAndDescription.getDescriptions(AccessFileFormat.class);
    }

    public static AccessFileFormat lookupDescription(String description) {
        return (AccessFileFormat)IEnumHasCodeAndDescription.lookupDescription(AccessFileFormat.class, (String)description, (IEnumHasCodeAndDescription)V2019);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public Database.FileFormat getFormat() {
        return this.format;
    }
}

