/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.caching.BaseCachingExecutionInfoLocation;
import org.apache.hop.execution.caching.CacheEntry;
import org.apache.hop.execution.caching.DatedId;
import org.apache.hop.execution.opensearch.RestCaller;
import org.apache.hop.execution.plugin.ExecutionInfoLocationPlugin;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@GuiPlugin(description="OpenSearch execution information location GUI elements")
@ExecutionInfoLocationPlugin(id="opensearch-location", name="OpenSearch location", description="Aggregates and caches execution information before storing in OpenSearch")
public class OpenSearchExecutionInfoLocation
extends BaseCachingExecutionInfoLocation
implements IExecutionInfoLocation {
    public static final Class<?> PKG = OpenSearchExecutionInfoLocation.class;
    @GuiWidgetElement(id="url", order="010", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n:org.apache.hop.execution.opensearch:OpenSearchExecutionInfoLocation.Url.Tooltip", label="i18n:org.apache.hop.execution.opensearch:OpenSearchExecutionInfoLocation.Url.Label")
    @HopMetadataProperty
    protected String url;
    @GuiWidgetElement(id="username", order="020", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.TEXT, password=false, toolTip="i18n:org.apache.hop.execution.opensearch:OpenSearchExecutionInfoLocation.Username.Tooltip", label="i18n:org.apache.hop.execution.opensearch:OpenSearchExecutionInfoLocation.Username.Label")
    @HopMetadataProperty
    protected String username;
    @GuiWidgetElement(id="password", order="030", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.TEXT, password=true, toolTip="i18n:org.apache.hop.execution.opensearch:OpenSearchExecutionInfoLocation.Password.Tooltip", label="i18n:org.apache.hop.execution.opensearch:OpenSearchExecutionInfoLocation.Password.Label")
    @HopMetadataProperty
    protected String password;
    @GuiWidgetElement(id="indexName", order="040", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n:org.apache.hop.execution.opensearch:OpenSearchExecutionInfoLocation.IndexName.Tooltip", label="i18n:org.apache.hop.execution.opensearch:OpenSearchExecutionInfoLocation.IndexName.Label")
    @HopMetadataProperty
    protected String indexName;
    @GuiWidgetElement(id="ignoreSsl", order="050", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.CHECKBOX, toolTip="i18n:org.apache.hop.execution.opensearch:OpenSearchExecutionInfoLocation.IgnoreSsl.Tooltip", label="i18n:org.apache.hop.execution.opensearch:OpenSearchExecutionInfoLocation.IgnoreSsl.Label")
    @HopMetadataProperty
    protected boolean ignoreSsl;
    protected String actualUrl;
    protected String actualUsername;
    protected String actualPassword;
    protected String actualIndexName;

    public OpenSearchExecutionInfoLocation() {
    }

    public OpenSearchExecutionInfoLocation(OpenSearchExecutionInfoLocation location) {
        super((BaseCachingExecutionInfoLocation)location);
        this.url = location.url;
        this.username = location.username;
        this.password = location.password;
        this.indexName = location.indexName;
        this.ignoreSsl = location.ignoreSsl;
        this.actualUrl = location.actualUrl;
        this.actualIndexName = location.actualIndexName;
        this.actualUsername = location.actualUsername;
        this.actualPassword = location.actualPassword;
    }

    public OpenSearchExecutionInfoLocation clone() {
        return new OpenSearchExecutionInfoLocation(this);
    }

    public void initialize(IVariables variables, IHopMetadataProvider metadataProvider) throws HopException {
        this.actualUrl = variables.resolve(this.url);
        this.actualUsername = variables.resolve(this.username);
        this.actualPassword = variables.resolve(this.password);
        this.actualIndexName = variables.resolve(this.indexName);
        super.initialize(variables, metadataProvider);
    }

    protected void persistCacheEntry(CacheEntry cacheEntry) throws HopException {
        try {
            cacheEntry.calculateSummary();
            URI uri = URI.create(this.actualUrl);
            URI postUri = StringUtils.isEmpty((String)cacheEntry.getInternalId()) ? uri.resolve(this.actualIndexName + "/_doc") : uri.resolve(this.actualIndexName + "/_doc/" + cacheEntry.getInternalId());
            ObjectMapper mapper = new ObjectMapper();
            String body = mapper.writeValueAsString((Object)cacheEntry);
            RestCaller restCaller = new RestCaller(this.metadataProvider, postUri.toString(), this.actualUsername, this.actualPassword, "POST", body, this.ignoreSsl, this.getHeaders());
            String responseBody = restCaller.execute();
            Long statusCode = restCaller.getStatusCode();
            OpenSearchExecutionInfoLocation.checkStatusCode(responseBody, statusCode, 200L, 201L);
            JSONParser parser = new JSONParser();
            JSONObject bodyJs = (JSONObject)parser.parse(responseBody);
            String documentId = (String)bodyJs.get((Object)"_id");
            cacheEntry.setInternalId(documentId);
            cacheEntry.setLastWritten(new Date());
        }
        catch (Exception e) {
            throw new HopException("Error writing caching file entry to OpenSearch", (Throwable)e);
        }
    }

    private String getAuthorizationHeaderValue(String actualUsername, String actualPassword) {
        String userPass = actualUsername + ":" + actualPassword;
        return "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes());
    }

    public void deleteCacheEntry(CacheEntry cacheEntry) throws HopException {
        try {
            URI uri = URI.create(this.actualUrl);
            URI postUri = uri.resolve(this.actualIndexName + "/_search");
            String body = "        {\n          \"query\": {\n            \"query_string\": {\n              \"query\": \"executionId\"\n            }\n          }, \"_source\": false\n        }\n";
            body = body.replace("executionId", cacheEntry.getId());
            RestCaller restCaller = new RestCaller(this.metadataProvider, postUri.toString(), this.actualUsername, this.actualPassword, "POST", body, this.ignoreSsl, this.getHeaders());
            String responseBody = restCaller.execute();
            Long statusCode = restCaller.getStatusCode();
            OpenSearchExecutionInfoLocation.checkStatusCode(responseBody, statusCode, 200L, 201L);
            JSONParser parser = new JSONParser();
            JSONObject j = (JSONObject)parser.parse(responseBody);
            JSONObject jHitsTop = (JSONObject)j.get((Object)"hits");
            if (jHitsTop == null) {
                return;
            }
            JSONArray jHits = (JSONArray)jHitsTop.get((Object)"hits");
            if (jHits == null || jHits.isEmpty()) {
                return;
            }
            for (Object hit : jHits) {
                JSONObject jHit = (JSONObject)hit;
                String elasticId = (String)jHit.get((Object)"_id");
                URI deleteUri = uri.resolve(this.actualIndexName + "/_doc/" + elasticId);
                RestCaller deleteRestCaller = new RestCaller(this.metadataProvider, deleteUri.toString(), this.actualUsername, this.actualPassword, "DELETE", "", this.ignoreSsl, this.getHeaders());
                responseBody = deleteRestCaller.execute();
                OpenSearchExecutionInfoLocation.checkStatusCode(responseBody, deleteRestCaller.getStatusCode(), 200L);
            }
        }
        catch (Exception e) {
            throw new HopException("Error deleting caching file entry from OpenSearch", (Throwable)e);
        }
        finally {
            this.cache.remove(cacheEntry.getId());
        }
    }

    private static void checkStatusCode(String responseBody, Long responseCode, Long ... statusCodes) throws HopException {
        if (responseCode == null) {
            throw new HopException("No status code received with response body: " + responseBody);
        }
        boolean found = false;
        for (Long statusCode : statusCodes) {
            if (!statusCode.equals(responseCode)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new HopException("Invalid status code received from OpenSearch: '" + responseCode + "' with response: " + responseBody);
        }
    }

    private Map<String, String> getHeaders() {
        return Map.of("Content-Type", "application/json", "Accept", "application/json", "Authorization", this.getAuthorizationHeaderValue(this.actualUsername, this.actualPassword));
    }

    protected synchronized CacheEntry loadCacheEntry(String executionId) throws HopException {
        try {
            URI uri = URI.create(this.actualUrl);
            URI postUri = uri.resolve(this.actualIndexName + "/_search");
            String body = "    {\n       \"query\": {\n         \"match\": {\n           \"id\": \"executionId\"\n         }\n       }\n     }\n";
            body = body.replace("executionId", executionId);
            HttpRequest request = HttpRequest.newBuilder().uri(postUri).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", this.getAuthorizationHeaderValue(this.actualUsername, this.actualPassword)).POST(HttpRequest.BodyPublishers.ofString(body)).build();
            RestCaller restCaller = new RestCaller(this.metadataProvider, postUri.toString(), this.actualUsername, this.actualPassword, "POST", body, this.ignoreSsl, this.getHeaders());
            String responseBody = restCaller.execute();
            Long statusCode = restCaller.getStatusCode();
            OpenSearchExecutionInfoLocation.checkStatusCode(responseBody, statusCode, 200L, 201L);
            JSONParser parser = new JSONParser();
            JSONObject j = (JSONObject)parser.parse(responseBody);
            JSONObject jHitsTop = (JSONObject)j.get((Object)"hits");
            if (jHitsTop == null) {
                return null;
            }
            JSONArray jHits = (JSONArray)jHitsTop.get((Object)"hits");
            if (jHits == null || jHits.isEmpty()) {
                return null;
            }
            JSONObject jHit = (JSONObject)jHits.get(0);
            JSONObject jSource = (JSONObject)jHit.get((Object)"_source");
            if (jSource == null) {
                return null;
            }
            String json = jSource.toJSONString();
            ObjectMapper objectMapper = new ObjectMapper();
            return (CacheEntry)objectMapper.readValue(json, CacheEntry.class);
        }
        catch (Exception e) {
            throw new HopException("Error loading execution information location from OpenSearch using executionId '" + executionId + "'", (Throwable)e);
        }
    }

    protected void retrieveIds(boolean includeChildren, Set<DatedId> ids, int limit) throws HopException {
        try {
            URI uri = URI.create(this.actualUrl);
            URI postUri = uri.resolve(this.actualIndexName + "/_search");
            String body = "  {\n    __LIMIT_CLAUSE__\n    \"from\": 0,\n    \"query\" : { \"match_all\" : {} },\n    \"fields\": [ \"id\", \"execution.executionStartDate\" ],\n    \"sort\" : [ { \"execution.executionStartDate\" : {\"order\" : \"desc\" }} ],\n    \"_source\": false\n  }\n";
            Object limitClause = "";
            if (limit > 0) {
                limitClause = "\"size\": " + limit + ",";
            }
            body = body.replace("__LIMIT_CLAUSE__", (CharSequence)limitClause);
            RestCaller restCaller = new RestCaller(this.metadataProvider, postUri.toString(), this.actualUsername, this.actualPassword, "POST", body, this.ignoreSsl, this.getHeaders());
            String responseBody = restCaller.execute();
            Long statusCode = restCaller.getStatusCode();
            OpenSearchExecutionInfoLocation.checkStatusCode(responseBody, statusCode, 200L, 201L);
            JSONParser parser = new JSONParser();
            JSONObject j = (JSONObject)parser.parse(responseBody);
            JSONObject jHitsTop = (JSONObject)j.get((Object)"hits");
            if (jHitsTop == null) {
                return;
            }
            JSONArray jHits = (JSONArray)jHitsTop.get((Object)"hits");
            if (jHits == null || jHits.isEmpty()) {
                return;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            for (Object hit : jHits) {
                JSONObject jHit = (JSONObject)hit;
                JSONObject jHitsFields = (JSONObject)jHit.get((Object)"fields");
                JSONArray jHitsFieldsIds = (JSONArray)jHitsFields.get((Object)"id");
                if (jHitsFieldsIds == null || jHitsFieldsIds.isEmpty()) continue;
                String id = (String)jHitsFieldsIds.get(0);
                JSONArray jHitsFieldsStart = (JSONArray)jHitsFields.get((Object)"execution.executionStartDate");
                if (jHitsFieldsStart == null || jHitsFieldsStart.isEmpty()) continue;
                String startDate = (String)jHitsFieldsStart.get(0);
                ids.add(new DatedId(id, sdf.parse(startDate)));
            }
        }
        catch (Exception e) {
            throw new HopException("Error finding execution ids from OpenSearch", (Throwable)e);
        }
    }

    @GuiWidgetElement(id="createIndexButton", order="035", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.BUTTON, label="i18n::OpenSearchExecutionInfoLocation.CreateIndex.Label", toolTip="i18n::OpenSearchExecutionInfoLocation.CreateIndex.Tooltip")
    public void createIndexButton(Object object) {
        HopGui hopGui = HopGui.getInstance();
        OpenSearchExecutionInfoLocation location = (OpenSearchExecutionInfoLocation)((Object)object);
        try {
            Object result;
            location.initialize(hopGui.getVariables(), (IHopMetadataProvider)hopGui.getMetadataProvider());
            String putBody = "  {\n    \"mappings\" : {\n      \"properties\": {\n        \"id\": { \"type\" : \"text\"},\n        \"name\": { \"type\" : \"text\"},\n        \"execution.id\": { \"type\" : \"text\"},\n        \"execution.name\": { \"type\" : \"text\"},\n        \"execution.filename\": { \"type\" : \"text\"},\n        \"execution.executionType\": { \"type\" : \"text\"},\n        \"execution.parentId\": { \"type\" : \"text\"},\n        \"execution.registrationDate\": { \"type\": \"date\" },\n        \"execution.executionStartDate\": { \"type\": \"date\" },\n        \"executionState.updateTime\": { \"type\": \"date\" },\n        \"executionState.executionEndDate\": { \"type\": \"date\" },\n        \"childExecutions\": { \"type\": \"object\", \"enabled\" : false },\n        \"childExecutionStates\": { \"type\": \"object\", \"enabled\" : false },\n        \"childExecutionData\": { \"type\": \"object\", \"enabled\" : false }\n      }\n    }, \"settings\": {\n      \"index.mapping.total_fields.limit\": 500\n    }\n  }\n";
            RestCaller restCaller = new RestCaller((IHopMetadataProvider)new MemoryMetadataProvider(), location.actualUrl + "/" + location.actualIndexName, location.actualUsername, location.actualPassword, "PUT", putBody, location.ignoreSsl, this.getHeaders());
            try {
                result = restCaller.execute();
            }
            catch (Exception e) {
                result = Const.getSimpleStackTrace((Throwable)e);
            }
            if (restCaller.getResult() == null || restCaller.getResult().getNrErrors() > 0L) {
                result = (String)result + Const.CR + "Logging: " + restCaller.getLoggingText();
            }
            EnterTextDialog dialog = new EnterTextDialog(hopGui.getShell(), "Results", restCaller.getMethod() + " on " + restCaller.getUrl() + ":", "Code: " + restCaller.getStatusCode() + Const.CR + Const.NVL((String)result, (String)"Failed") + Const.CR + Const.CR + "The result of the PUT on : " + restCaller.getUrl() + " with body: " + Const.CR + putBody, true);
            dialog.setReadOnly();
            dialog.open();
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), "Error", "Error creating OpenSearch index " + location.indexName, e);
        }
    }

    public String getPluginId() {
        return "opensearch-location";
    }

    public void setPluginId(String pluginId) {
    }

    public String getPluginName() {
        return "OpenSearch location";
    }

    public void setPluginName(String pluginName) {
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Generated
    public boolean isIgnoreSsl() {
        return this.ignoreSsl;
    }

    @Generated
    public String getActualUrl() {
        return this.actualUrl;
    }

    @Generated
    public String getActualUsername() {
        return this.actualUsername;
    }

    @Generated
    public String getActualPassword() {
        return this.actualPassword;
    }

    @Generated
    public String getActualIndexName() {
        return this.actualIndexName;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Generated
    public void setIgnoreSsl(boolean ignoreSsl) {
        this.ignoreSsl = ignoreSsl;
    }

    @Generated
    public void setActualUrl(String actualUrl) {
        this.actualUrl = actualUrl;
    }

    @Generated
    public void setActualUsername(String actualUsername) {
        this.actualUsername = actualUsername;
    }

    @Generated
    public void setActualPassword(String actualPassword) {
        this.actualPassword = actualPassword;
    }

    @Generated
    public void setActualIndexName(String actualIndexName) {
        this.actualIndexName = actualIndexName;
    }
}

