/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.client.internal.jpountz.lz4.LZ4Factory;
import com.clickhouse.client.internal.jpountz.lz4.LZ4FastDecompressor;
import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseByteUtils;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseCityHash;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.stream.AbstractByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.StreamCorruptedException;

@Deprecated
public class Lz4InputStream
extends AbstractByteArrayInputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    static final byte MAGIC = -126;
    static final int HEADER_LENGTH = 25;
    private final LZ4FastDecompressor decompressor = factory.fastDecompressor();
    private final InputStream input;
    private final byte[] header;
    private byte[] compressedBlock;

    private boolean readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.input.read(b, off + n, len - n);
            if (count >= 0) continue;
            if (n == 0) {
                return false;
            }
            throw new StreamCorruptedException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", n, len));
        }
        return true;
    }

    @Override
    protected boolean reusableBuffer() {
        return true;
    }

    @Override
    protected int updateBuffer() throws IOException {
        this.position = 0;
        if (!this.readFully(this.header, 0, 25)) {
            this.buffer = ClickHouseByteBuffer.EMPTY_BYTES;
            this.limit = 0;
            return 0;
        }
        if (this.header[16] != -126) {
            throw new IOException(ClickHouseUtils.format("Magic is not correct - expect [%d] but got [%d]", (byte)-126, this.header[16]));
        }
        int compressedSizeWithHeader = ClickHouseByteUtils.getInt32(this.header, 17);
        int uncompressedSize = ClickHouseByteUtils.getInt32(this.header, 21);
        int offset = 9;
        byte[] block = this.compressedBlock.length >= compressedSizeWithHeader ? this.compressedBlock : (this.compressedBlock = new byte[compressedSizeWithHeader]);
        block[0] = this.header[16];
        ClickHouseByteUtils.setInt32(block, 1, compressedSizeWithHeader);
        ClickHouseByteUtils.setInt32(block, 5, uncompressedSize);
        if (!this.readFully(block, offset, compressedSizeWithHeader - offset)) {
            throw new StreamCorruptedException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", 0, compressedSizeWithHeader - offset));
        }
        long[] real = ClickHouseCityHash.cityHash128(block, 0, compressedSizeWithHeader);
        if (real[0] != ClickHouseByteUtils.getInt64(this.header, 0) || real[1] != ClickHouseByteUtils.getInt64(this.header, 8)) {
            throw new InvalidObjectException("Checksum doesn't match: corrupted data.");
        }
        byte[] buf = this.buffer.length >= uncompressedSize ? this.buffer : (this.buffer = new byte[uncompressedSize]);
        this.decompressor.decompress(block, offset, buf, 0, uncompressedSize);
        if (this.copyTo != null) {
            this.copyTo.write(buf, 0, uncompressedSize);
        }
        this.limit = uncompressedSize;
        return this.limit;
    }

    public Lz4InputStream(InputStream stream) {
        this(null, stream, null);
    }

    public Lz4InputStream(ClickHousePassThruStream stream, InputStream input, Runnable postCloseAction) {
        super(stream, null, postCloseAction);
        this.input = ClickHouseChecker.nonNull(input, "InputStream");
        this.header = new byte[25];
        this.compressedBlock = ClickHouseByteBuffer.EMPTY_BYTES;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.input.close();
            }
            finally {
                super.close();
            }
        }
    }
}

