/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlDelete
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DELETE", SqlKind.DELETE){

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlDelete(pos, operands[0], operands[1], (SqlSelect)operands[2], (SqlIdentifier)operands[3]);
        }
    };
    SqlNode targetTable;
    @Nullable SqlNode condition;
    @Nullable SqlSelect sourceSelect;
    @Nullable SqlIdentifier alias;

    public SqlDelete(SqlParserPos pos, SqlNode targetTable, @Nullable SqlNode condition, @Nullable SqlSelect sourceSelect, @Nullable SqlIdentifier alias) {
        super(pos);
        this.targetTable = targetTable;
        this.condition = condition;
        this.sourceSelect = sourceSelect;
        this.alias = alias;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.DELETE;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.targetTable, this.condition, this.sourceSelect, this.alias);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.targetTable = operand;
                break;
            }
            case 1: {
                this.condition = operand;
                break;
            }
            case 2: {
                this.sourceSelect = (SqlSelect)operand;
                break;
            }
            case 3: {
                this.alias = (SqlIdentifier)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNode getTargetTable() {
        return this.targetTable;
    }

    public @Nullable SqlIdentifier getAlias() {
        return this.alias;
    }

    public @Nullable SqlNode getCondition() {
        return this.condition;
    }

    public @Nullable SqlSelect getSourceSelect() {
        return this.sourceSelect;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlNode condition;
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SELECT, "DELETE FROM", "");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.targetTable.unparse(writer, opLeft, opRight);
        SqlIdentifier alias = this.alias;
        if (alias != null) {
            writer.keyword("AS");
            alias.unparse(writer, opLeft, opRight);
        }
        if ((condition = this.condition) != null) {
            writer.sep("WHERE");
            condition.unparse(writer, opLeft, opRight);
        }
        writer.endList(frame);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateDelete(this);
    }

    public void setSourceSelect(SqlSelect sourceSelect) {
        this.sourceSelect = sourceSelect;
    }
}

