/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.tostring.S;

public class IgniteConcurrentMultiPairQueue<K, V> {
    public static final IgniteConcurrentMultiPairQueue EMPTY = new IgniteConcurrentMultiPairQueue(Map.of());
    private final V[][] vals;
    private final int[] lenSeq;
    private final AtomicInteger pos = new AtomicInteger();
    private final int maxPos;
    private final K[] keysArr;

    public IgniteConcurrentMultiPairQueue(Map<K, ? extends Collection<V>> items) {
        int pairCnt = (int)items.entrySet().stream().map(Map.Entry::getValue).filter(Predicate.not(Collection::isEmpty)).count();
        this.vals = new Object[pairCnt][];
        this.keysArr = new Object[pairCnt];
        this.lenSeq = new int[pairCnt];
        int keyPos = 0;
        int size = -1;
        for (Map.Entry<K, Collection<V>> p : items.entrySet()) {
            if (p.getValue().isEmpty()) continue;
            this.keysArr[keyPos] = p.getKey();
            this.lenSeq[keyPos] = size += p.getValue().size();
            this.vals[keyPos++] = p.getValue().toArray();
        }
        this.maxPos = size + 1;
    }

    public IgniteConcurrentMultiPairQueue(Collection<IgniteBiTuple<K, V[]>> items) {
        int pairCnt = (int)items.stream().map(Map.Entry::getValue).filter(k -> ((Object[])k).length > 0).count();
        this.vals = new Object[pairCnt][];
        this.keysArr = new Object[pairCnt];
        this.lenSeq = new int[pairCnt];
        int keyPos = 0;
        int size = -1;
        for (Map.Entry entry : items) {
            if (((Object[])entry.getValue()).length == 0) continue;
            this.keysArr[keyPos] = entry.getKey();
            this.lenSeq[keyPos] = size += ((Object[])entry.getValue()).length;
            this.vals[keyPos++] = (Object[])entry.getValue();
        }
        this.maxPos = size + 1;
    }

    public boolean next(Result<K, V> res) {
        int absPos = this.pos.getAndIncrement();
        if (absPos >= this.maxPos) {
            res.set(null, null, 0);
            return false;
        }
        int segment = res.getSegment();
        if (absPos > this.lenSeq[segment]) {
            segment = (segment = Arrays.binarySearch(this.lenSeq, segment, this.lenSeq.length - 1, absPos)) < 0 ? -segment - 1 : segment;
        }
        int relPos = segment == 0 ? absPos : absPos - this.lenSeq[segment - 1] - 1;
        K key = this.keysArr[segment];
        res.set(key, this.vals[segment][relPos], segment);
        return true;
    }

    public boolean isEmpty() {
        return this.pos.get() >= this.maxPos;
    }

    public int initialSize() {
        return this.maxPos;
    }

    public int size() {
        int currentPosition = this.pos.get();
        return currentPosition >= this.maxPos ? 0 : this.maxPos - currentPosition;
    }

    public static class Result<K, V> {
        private int segment;
        private K key;
        private V val;

        public void set(K k, V v, int seg) {
            this.key = k;
            this.val = v;
            this.segment = seg;
        }

        private int getSegment() {
            return this.segment;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.val;
        }

        public String toString() {
            return S.toString(Result.class, this);
        }
    }
}

