/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare.pruning;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite3.internal.sql.engine.exec.mapping.MappedFragment;
import org.apache.ignite3.internal.sql.engine.prepare.Fragment;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruner;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningColumns;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningPredicate;
import org.apache.ignite3.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.jetbrains.annotations.Nullable;

public class PartitionPrunerImpl
implements PartitionPruner {
    @Override
    public List<MappedFragment> apply(List<MappedFragment> mappedFragments, Object[] dynamicParameters, PartitionPruningMetadata metadata) {
        if (metadata.data().isEmpty()) {
            return mappedFragments;
        }
        ArrayList<MappedFragment> updatedFragments = new ArrayList<MappedFragment>(mappedFragments.size());
        Long2ObjectArrayMap newNodesByExchangeId = new Long2ObjectArrayMap();
        for (MappedFragment mappedFragment : mappedFragments) {
            Fragment fragment = mappedFragment.fragment();
            if (fragment.tables().isEmpty()) {
                updatedFragments.add(mappedFragment);
                continue;
            }
            PartitionPruningMetadata fragmentPruningMetadata = metadata.subset(fragment.tables());
            if (fragmentPruningMetadata.data().isEmpty()) {
                updatedFragments.add(mappedFragment);
                continue;
            }
            boolean containCorrelatedVariables = fragmentPruningMetadata.data().values().stream().anyMatch(PartitionPruningColumns::containCorrelatedVariables);
            if (containCorrelatedVariables) {
                updatedFragments.add(mappedFragment.withPartitionPruningMetadata(fragmentPruningMetadata));
                continue;
            }
            MappedFragment newFragment = PartitionPrunerImpl.updateColocationGroups(mappedFragment, fragmentPruningMetadata, dynamicParameters);
            if (newFragment == null) {
                updatedFragments.add(mappedFragment);
                continue;
            }
            if (fragment.root() instanceof IgniteSender) {
                long exchangeId = ((IgniteSender)fragment.root()).exchangeId();
                newNodesByExchangeId.put(exchangeId, newFragment.nodes());
            }
            updatedFragments.add(newFragment);
        }
        if (newNodesByExchangeId.isEmpty()) {
            return updatedFragments;
        }
        boolean updatedExchangers = false;
        for (int i = 0; i < mappedFragments.size(); ++i) {
            MappedFragment mappedFragment = mappedFragments.get(i);
            MappedFragment newFragment = PartitionPrunerImpl.updateSourceExchanges(mappedFragment, (Long2ObjectMap<List<String>>)newNodesByExchangeId);
            if (newFragment == null) continue;
            updatedFragments.set(i, newFragment);
            updatedExchangers = true;
        }
        assert (updatedExchangers) : "No source exchange was updated. Mapping is probably broken " + (Long2ObjectMap)newNodesByExchangeId;
        return updatedFragments;
    }

    @Nullable
    private static MappedFragment updateColocationGroups(MappedFragment mappedFragment, PartitionPruningMetadata pruningMetadata, Object[] dynamicParameters) {
        Fragment fragment = mappedFragment.fragment();
        Long2ObjectArrayMap newColocationGroups = new Long2ObjectArrayMap();
        for (Long2ObjectMap.Entry entry : fragment.tables().long2ObjectEntrySet()) {
            long sourceId = entry.getLongKey();
            IgniteTable table = (IgniteTable)entry.getValue();
            PartitionPruningColumns pruningColumns = pruningMetadata.get(sourceId);
            if (pruningColumns == null) continue;
            ColocationGroup colocationGroup = (ColocationGroup)mappedFragment.groupsBySourceId().get(sourceId);
            assert (colocationGroup != null) : "No colocation group#" + sourceId;
            ColocationGroup newColocationGroup = PartitionPruningPredicate.prunePartitions(sourceId, table, pruningColumns, dynamicParameters, colocationGroup);
            newColocationGroups.put(sourceId, (Object)newColocationGroup);
        }
        if (newColocationGroups.isEmpty()) {
            return null;
        }
        return mappedFragment.replaceColocationGroups((Long2ObjectMap<ColocationGroup>)newColocationGroups);
    }

    @Nullable
    private static MappedFragment updateSourceExchanges(MappedFragment mappedFragment, final Long2ObjectMap<List<String>> newNodesByExchangeId) {
        Fragment fragment = mappedFragment.fragment();
        final MappedFragment[] result = new MappedFragment[]{mappedFragment};
        IgniteRelShuttle updater = new IgniteRelShuttle(){

            @Override
            public IgniteRel visit(IgniteReceiver rel) {
                long exchangeId = rel.exchangeId();
                List newSourcesByExchange = (List)newNodesByExchangeId.get(exchangeId);
                if (newSourcesByExchange == null) {
                    return super.visit(rel);
                }
                MappedFragment current = result[0];
                result[0] = current.replaceExchangeSources(exchangeId, newSourcesByExchange);
                return super.visit(rel);
            }
        };
        fragment.root().accept(updater);
        if (result[0] != mappedFragment) {
            return result[0];
        }
        return null;
    }
}

