/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.distributed;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class InitMessage<I extends Serializable>
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final UUID procId;
    private final int type;
    private final I req;
    private final boolean waitClnRes;

    public InitMessage(UUID procId, DistributedProcess.DistributedProcessType type, I req, boolean waitClnRes) {
        this.procId = procId;
        this.type = type.ordinal();
        this.req = req;
        this.waitClnRes = waitClnRes;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        return mgr.createDiscoCacheOnCacheChange(topVer, discoCache);
    }

    public UUID processId() {
        return this.procId;
    }

    public int type() {
        return this.type;
    }

    public I request() {
        return this.req;
    }

    public boolean waitClientResults() {
        return this.waitClnRes;
    }

    public String toString() {
        return S.toString(InitMessage.class, this);
    }
}

