/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.metaservice;

import com.google.protobuf.Struct;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesProposalCRDT;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesProposer;
import org.apache.bifromq.basekv.proto.BalancerStateSnapshot;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class BaseKVStoreBalancerStatesProposer
implements IBaseKVStoreBalancerStatesProposer {
    private final Logger log;
    private final IBaseKVStoreBalancerStatesProposalCRDT proposalCRDT;

    BaseKVStoreBalancerStatesProposer(IBaseKVStoreBalancerStatesProposalCRDT proposalCRDT) {
        this.log = MDCLogger.getLogger(BaseKVStoreBalancerStatesProposer.class, (String[])new String[]{"clusterId", proposalCRDT.clusterId()});
        this.proposalCRDT = proposalCRDT;
    }

    @Override
    public CompletableFuture<IBaseKVStoreBalancerStatesProposer.ProposalResult> proposeRunState(String balancerFactoryClassFQN, boolean disable) {
        BalancerStateSnapshot currentProposal = this.proposalCRDT.expectedBalancerState(balancerFactoryClassFQN).orElse(BalancerStateSnapshot.getDefaultInstance());
        if (currentProposal.getDisable() == disable) {
            return CompletableFuture.completedFuture(IBaseKVStoreBalancerStatesProposer.ProposalResult.ACCEPTED);
        }
        long now = HLC.INST.get();
        BalancerStateSnapshot updatedState = BalancerStateSnapshot.newBuilder().setDisable(disable).setLoadRules(currentProposal.getLoadRules()).setHlc(now).build();
        return this.proposeBalancerState(balancerFactoryClassFQN, updatedState);
    }

    @Override
    public CompletableFuture<IBaseKVStoreBalancerStatesProposer.ProposalResult> proposeLoadRules(String balancerFactoryClassFQN, Struct loadRules) {
        BalancerStateSnapshot currentProposal = this.proposalCRDT.expectedBalancerState(balancerFactoryClassFQN).orElse(BalancerStateSnapshot.getDefaultInstance());
        if (currentProposal.getLoadRules().equals((Object)loadRules)) {
            return CompletableFuture.completedFuture(IBaseKVStoreBalancerStatesProposer.ProposalResult.ACCEPTED);
        }
        long now = HLC.INST.get();
        BalancerStateSnapshot updatedState = BalancerStateSnapshot.newBuilder().setDisable(currentProposal.getDisable()).setLoadRules(loadRules).setHlc(now).build();
        return this.proposeBalancerState(balancerFactoryClassFQN, updatedState);
    }

    @Override
    public CompletableFuture<Void> clearProposedState(String balancerFactoryClassFQN) {
        return this.proposalCRDT.removeBalancerState(balancerFactoryClassFQN);
    }

    @Override
    public void stop() {
    }

    private CompletableFuture<IBaseKVStoreBalancerStatesProposer.ProposalResult> proposeBalancerState(String balancerFactoryClass, BalancerStateSnapshot state) {
        this.log.debug("Propose balancer state: balancerClass={}, state={}", (Object)balancerFactoryClass, (Object)state);
        CompletableFuture<IBaseKVStoreBalancerStatesProposer.ProposalResult> resultFuture = new CompletableFuture<IBaseKVStoreBalancerStatesProposer.ProposalResult>();
        long now = state.getHlc();
        this.proposalCRDT.expectedBalancerStates().mapOptional(observed -> {
            if (!observed.containsKey(balancerFactoryClass)) {
                return Optional.empty();
            }
            BalancerStateSnapshot effective = (BalancerStateSnapshot)observed.get(balancerFactoryClass);
            if (effective.getHlc() < now) {
                return Optional.empty();
            }
            if (state.getDisable() == effective.getDisable() && state.getLoadRules().equals((Object)effective.getLoadRules())) {
                return Optional.of(IBaseKVStoreBalancerStatesProposer.ProposalResult.ACCEPTED);
            }
            return Optional.of(IBaseKVStoreBalancerStatesProposer.ProposalResult.OVERRIDDEN);
        }).take(1L).subscribe(resultFuture::complete, resultFuture::completeExceptionally);
        this.proposalCRDT.setBalancerState(balancerFactoryClass, state.getDisable(), state.getLoadRules());
        return resultFuture;
    }
}

