/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.ratelimiter;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.ratelimiter.TokenBucket;
import org.apache.polaris.service.ratelimiter.TokenBucketConfiguration;
import org.apache.polaris.service.ratelimiter.TokenBucketFactory;

@ApplicationScoped
@Identifier(value="default")
public class DefaultTokenBucketFactory
implements TokenBucketFactory {
    private final long requestsPerSecond;
    private final Duration window;
    private final Clock clock;
    private final Map<String, TokenBucket> perRealmBuckets = new ConcurrentHashMap<String, TokenBucket>();

    @Inject
    public DefaultTokenBucketFactory(TokenBucketConfiguration configuration, Clock clock) {
        this(configuration.requestsPerSecond(), configuration.window(), clock);
    }

    public DefaultTokenBucketFactory(long requestsPerSecond, Duration window, Clock clock) {
        this.requestsPerSecond = requestsPerSecond;
        this.window = window;
        this.clock = clock;
    }

    @Override
    public TokenBucket getOrCreateTokenBucket(RealmContext realmContext) {
        String realmId = realmContext.getRealmIdentifier();
        return this.perRealmBuckets.computeIfAbsent(realmId, k -> new TokenBucket(this.requestsPerSecond, Math.multiplyExact(this.requestsPerSecond, this.window.toSeconds()), this.clock));
    }
}

