/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.util.List;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceFailureInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;

public class FragmentInstanceInfo
implements DataSet {
    private final FragmentInstanceState state;
    private String message;
    private long endTime;
    private List<FragmentInstanceFailureInfo> failureInfoList;
    private TSStatus errorCode;

    public FragmentInstanceInfo(FragmentInstanceState state) {
        this.state = state;
    }

    public FragmentInstanceInfo(FragmentInstanceState state, long endTime) {
        this.state = state;
        this.endTime = endTime;
    }

    public FragmentInstanceInfo(FragmentInstanceState state, long endTime, String message, List<FragmentInstanceFailureInfo> failureInfoList) {
        this(state, endTime);
        this.message = message;
        this.failureInfoList = failureInfoList;
    }

    public FragmentInstanceInfo(FragmentInstanceState state, long endTime, String message, List<FragmentInstanceFailureInfo> failureInfoList, TSStatus errorStatus) {
        this(state, endTime);
        this.message = message;
        this.failureInfoList = failureInfoList;
        this.errorCode = errorStatus;
    }

    public FragmentInstanceState getState() {
        return this.state;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Optional<TSStatus> getErrorCode() {
        return Optional.ofNullable(this.errorCode);
    }

    public List<FragmentInstanceFailureInfo> getFailureInfoList() {
        return this.failureInfoList;
    }
}

