/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.constraint.DynamicOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyValueImpl;

public class PropertyValueOperand
extends DynamicOperand {
    private final PropertyValueImpl operand;

    public PropertyValueOperand(PropertyValueImpl operand) {
        this.operand = operand;
    }

    public final PropertyState getPropertyState(ScoreNode sn, EvaluationContext context) throws RepositoryException {
        ItemStateManager ism = context.getItemStateManager();
        PropertyId propId = new PropertyId(sn.getNodeId(), this.operand.getPropertyQName());
        try {
            return (PropertyState)ism.getItemState(propId);
        }
        catch (NoSuchItemStateException e) {
            return null;
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }

    public final Property getProperty(ScoreNode sn, EvaluationContext context) throws RepositoryException {
        SessionImpl session = context.getSession();
        try {
            NodeImpl n = session.getNodeById(sn.getNodeId());
            return n.getProperty(this.operand.getPropertyName());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    @Override
    public Value[] getValues(ScoreNode sn, EvaluationContext context) throws RepositoryException {
        Property prop = this.getProperty(sn, context);
        if (prop == null) {
            return EMPTY;
        }
        if (prop.isMultiple()) {
            return prop.getValues();
        }
        return new Value[]{prop.getValue()};
    }
}

