/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.Create;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface CassandraBlobModule {
    public static final CassandraModule MODULE = CassandraModule.builder().table("blobParts").comment("Holds blob parts composing blobs in the default bucket.Messages` headers and bodies are stored, chunked in blobparts.").statement(statement -> (Create)statement.addPartitionKey("id", DataType.text()).addClusteringColumn("chunkNumber", DataType.cint()).addColumn("data", DataType.blob())).table("blobs").comment("Holds information for retrieving all blob parts composing this blob within the default bucket. Messages` headers and bodies are stored as blobparts.").statement(statement -> statement.addPartitionKey("id", DataType.text()).addClusteringColumn("position", DataType.cint())).table("blobPartsInBucket").comment("Holds blob parts composing blobs in a non-default bucket.Messages` headers and bodies are stored, chunked in blobparts.").statement(statement -> (Create)statement.addPartitionKey("bucket", DataType.text()).addPartitionKey("id", DataType.text()).addClusteringColumn("chunkNumber", DataType.cint()).addColumn("data", DataType.blob())).table("blobsInBucket").comment("Holds information for retrieving all blob parts composing this blob in a non-default bucket. Messages` headers and bodies are stored as blobparts.").statement(statement -> statement.addPartitionKey("bucket", DataType.text()).addPartitionKey("id", DataType.text()).addClusteringColumn("position", DataType.cint())).build();
}

