/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.FieldValueFactorModifier;
import org.opensearch.client.opensearch._types.query_dsl.FunctionScore;
import org.opensearch.client.opensearch._types.query_dsl.FunctionScoreVariant;
import org.opensearch.client.opensearch._types.query_dsl.ScoreFunctionBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class FieldValueFactorScoreFunction
extends ScoreFunctionBase
implements FunctionScoreVariant {
    private final String field;
    @Nullable
    private final Double factor;
    @Nullable
    private final Double missing;
    @Nullable
    private final FieldValueFactorModifier modifier;
    public static final JsonpDeserializer<FieldValueFactorScoreFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldValueFactorScoreFunction::setupFieldValueFactorScoreFunctionDeserializer);

    private FieldValueFactorScoreFunction(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.factor = builder.factor;
        this.missing = builder.missing;
        this.modifier = builder.modifier;
    }

    public static FieldValueFactorScoreFunction of(Function<Builder, ObjectBuilder<FieldValueFactorScoreFunction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FunctionScore.Kind _functionScoreKind() {
        return FunctionScore.Kind.FieldValueFactor;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Double factor() {
        return this.factor;
    }

    @Nullable
    public final Double missing() {
        return this.missing;
    }

    @Nullable
    public final FieldValueFactorModifier modifier() {
        return this.modifier;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.factor != null) {
            generator.writeKey("factor");
            generator.write(this.factor.doubleValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.doubleValue());
        }
        if (this.modifier != null) {
            generator.writeKey("modifier");
            this.modifier.serialize(generator, mapper);
        }
    }

    protected static void setupFieldValueFactorScoreFunctionDeserializer(ObjectDeserializer<Builder> op) {
        ScoreFunctionBase.setupScoreFunctionBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::factor, JsonpDeserializer.doubleDeserializer(), "factor");
        op.add(Builder::missing, JsonpDeserializer.doubleDeserializer(), "missing");
        op.add(Builder::modifier, FieldValueFactorModifier._DESERIALIZER, "modifier");
    }

    public static class Builder
    extends ScoreFunctionBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FieldValueFactorScoreFunction> {
        private String field;
        @Nullable
        private Double factor;
        @Nullable
        private Double missing;
        @Nullable
        private FieldValueFactorModifier modifier;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder factor(@Nullable Double value) {
            this.factor = value;
            return this;
        }

        public final Builder missing(@Nullable Double value) {
            this.missing = value;
            return this;
        }

        public final Builder modifier(@Nullable FieldValueFactorModifier value) {
            this.modifier = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldValueFactorScoreFunction build() {
            this._checkSingleUse();
            return new FieldValueFactorScoreFunction(this);
        }
    }
}

