/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.nodes.IngestTotal;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Ingest
implements JsonpSerializable {
    private final Map<String, IngestTotal> pipelines;
    private final IngestTotal total;
    public static final JsonpDeserializer<Ingest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ingest::setupIngestDeserializer);

    private Ingest(Builder builder) {
        this.pipelines = ApiTypeHelper.unmodifiableRequired(builder.pipelines, (Object)this, "pipelines");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static Ingest of(Function<Builder, ObjectBuilder<Ingest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, IngestTotal> pipelines() {
        return this.pipelines;
    }

    public final IngestTotal total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.pipelines)) {
            generator.writeKey("pipelines");
            generator.writeStartObject();
            for (Map.Entry<String, IngestTotal> item0 : this.pipelines.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
    }

    protected static void setupIngestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pipelines, JsonpDeserializer.stringMapDeserializer(IngestTotal._DESERIALIZER), "pipelines");
        op.add(Builder::total, IngestTotal._DESERIALIZER, "total");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Ingest> {
        private Map<String, IngestTotal> pipelines;
        private IngestTotal total;

        public final Builder pipelines(Map<String, IngestTotal> map) {
            this.pipelines = Builder._mapPutAll(this.pipelines, map);
            return this;
        }

        public final Builder pipelines(String key, IngestTotal value) {
            this.pipelines = Builder._mapPut(this.pipelines, key, value);
            return this;
        }

        public final Builder pipelines(String key, Function<IngestTotal.Builder, ObjectBuilder<IngestTotal>> fn) {
            return this.pipelines(key, fn.apply(new IngestTotal.Builder()).build());
        }

        public final Builder total(IngestTotal value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<IngestTotal.Builder, ObjectBuilder<IngestTotal>> fn) {
            return this.total(fn.apply(new IngestTotal.Builder()).build());
        }

        @Override
        public Ingest build() {
            this._checkSingleUse();
            return new Ingest(this);
        }
    }
}

