/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.main;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.message.Literal;

public class OutputStreamImapResponseWriter
implements ImapResponseWriter {
    public static final int BUFFER_SIZE = 1024;
    private final OutputStream output;
    private FlushCallback flushCallback;

    public OutputStreamImapResponseWriter(OutputStream output) {
        this.output = output;
        this.flushCallback = () -> {};
    }

    public void setFlushCallback(FlushCallback flushCallback) {
        this.flushCallback = flushCallback;
    }

    @Override
    public void write(Literal literal) throws IOException {
        this.flushCallback.run();
        try (InputStream in = literal.getInputStream();){
            IOUtils.copy((InputStream)in, (OutputStream)this.output, (int)1024);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.output.write(buffer);
    }

    @FunctionalInterface
    static interface FlushCallback {
        public void run() throws IOException;
    }
}

