/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.postgres.quota;

import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresQuotaDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(PostgresQuotaCurrentValueTable.TABLE).addTable(PostgresQuotaLimitTable.TABLE).build();

    public static interface PostgresQuotaCurrentValueTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"quota_current_value");
        public static final Field<String> IDENTIFIER = DSL.field((String)"identifier", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> COMPONENT = DSL.field((String)"component", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> TYPE = DSL.field((String)"type", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<Long> CURRENT_VALUE = DSL.field((Name)DSL.name((String[])new String[]{TABLE_NAME.getName(), "current_value"}), (DataType)SQLDataType.BIGINT.notNull());
        public static final Name PRIMARY_KEY_CONSTRAINT_NAME = DSL.name((String)"quota_current_value_primary_key");
        public static final PostgresTable TABLE = PostgresTable.name(TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(IDENTIFIER).column(COMPONENT).column(TYPE).column(CURRENT_VALUE).constraint((Constraint)DSL.constraint((Name)PRIMARY_KEY_CONSTRAINT_NAME).primaryKey(new Field[]{IDENTIFIER, COMPONENT, TYPE}))).disableRowLevelSecurity().build();
    }

    public static interface PostgresQuotaLimitTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"quota_limit");
        public static final Field<String> QUOTA_SCOPE = DSL.field((String)"quota_scope", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> IDENTIFIER = DSL.field((String)"identifier", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> QUOTA_COMPONENT = DSL.field((String)"quota_component", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> QUOTA_TYPE = DSL.field((String)"quota_type", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<Long> QUOTA_LIMIT = DSL.field((String)"quota_limit", (DataType)SQLDataType.BIGINT);
        public static final Name PK_CONSTRAINT_NAME = DSL.name((String)"quota_limit_pkey");
        public static final PostgresTable TABLE = PostgresTable.name(TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(QUOTA_SCOPE).column(IDENTIFIER).column(QUOTA_COMPONENT).column(QUOTA_TYPE).column(QUOTA_LIMIT).constraint((Constraint)DSL.constraint((Name)PK_CONSTRAINT_NAME).primaryKey(new Field[]{QUOTA_SCOPE, IDENTIFIER, QUOTA_COMPONENT, QUOTA_TYPE}))).disableRowLevelSecurity().build();
    }
}

