/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.upload;

import com.github.f4b6a3.uuid.UuidCreator;
import com.google.common.io.CountingInputStream;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.UUID;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.Upload;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.model.UploadNotFoundException;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.postgres.upload.PostgresUploadDAO;
import org.apache.james.mailbox.model.ContentType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresUploadRepository
implements UploadRepository {
    public static final BucketName UPLOAD_BUCKET = BucketName.of((String)"jmap-uploads");
    private final BlobId.Factory blobIdFactory;
    private final BlobStoreDAO blobStoreDAO;
    private final Clock clock;
    private final PostgresUploadDAO.Factory uploadDAOFactory;
    private final PostgresUploadDAO byPassRLSUploadDAO;

    @Inject
    @Singleton
    public PostgresUploadRepository(BlobId.Factory blobIdFactory, BlobStoreDAO blobStoreDAO, Clock clock, PostgresUploadDAO.Factory uploadDAOFactory, PostgresUploadDAO byPassRLSUploadDAO) {
        this.blobIdFactory = blobIdFactory;
        this.blobStoreDAO = blobStoreDAO;
        this.clock = clock;
        this.uploadDAOFactory = uploadDAOFactory;
        this.byPassRLSUploadDAO = byPassRLSUploadDAO;
    }

    public Mono<UploadMetaData> upload(InputStream data, ContentType contentType, Username user) {
        UploadId uploadId = this.generateId();
        BlobId blobId = this.blobIdFactory.of(uploadId.asString());
        PostgresUploadDAO uploadDAO = this.uploadDAOFactory.create(user.getDomainPart());
        return Mono.fromCallable(() -> new CountingInputStream(data)).flatMap(countingInputStream -> Mono.from((Publisher)this.blobStoreDAO.save(UPLOAD_BUCKET, blobId, (InputStream)countingInputStream)).thenReturn(countingInputStream)).map(countingInputStream -> UploadMetaData.from((UploadId)uploadId, (ContentType)contentType, (long)countingInputStream.getCount(), (BlobId)blobId, (Instant)this.clock.instant())).flatMap(uploadMetaData -> uploadDAO.insert((UploadMetaData)uploadMetaData, user));
    }

    public Mono<Upload> retrieve(UploadId id, Username user) {
        return this.uploadDAOFactory.create(user.getDomainPart()).get(id, user).flatMap(upload -> Mono.from((Publisher)this.blobStoreDAO.readReactive(UPLOAD_BUCKET, upload.blobId())).map(inputStream -> Upload.from((UploadMetaData)upload, () -> inputStream))).switchIfEmpty(Mono.error(() -> new UploadNotFoundException(id)));
    }

    public Mono<Boolean> delete(UploadId id, Username user) {
        return this.uploadDAOFactory.create(user.getDomainPart()).delete(id, user);
    }

    public Flux<UploadMetaData> listUploads(Username user) {
        return this.uploadDAOFactory.create(user.getDomainPart()).list(user);
    }

    public Mono<Void> deleteByUploadDateBefore(Duration expireDuration) {
        LocalDateTime expirationTime = (LocalDateTime)PostgresCommons.INSTANT_TO_LOCAL_DATE_TIME.apply(this.clock.instant().minus(expireDuration));
        return Flux.from(this.byPassRLSUploadDAO.listByUploadDateBefore(expirationTime)).flatMap(uploadPair -> {
            Username username = (Username)uploadPair.getRight();
            UploadMetaData upload = (UploadMetaData)uploadPair.getLeft();
            return Mono.from((Publisher)this.blobStoreDAO.delete(UPLOAD_BUCKET, upload.blobId())).then(this.byPassRLSUploadDAO.delete(upload.uploadId(), username));
        }, 16).then();
    }

    private UploadId generateId() {
        return UploadId.from((UUID)UuidCreator.getTimeOrderedEpoch());
    }
}

