/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.sparql.util.TranslationTable;

public enum ResultsFormat {
    XML(ResultSetLang.RS_XML, RDFFormat.RDFXML_ABBREV),
    JSON(ResultSetLang.RS_JSON, RDFFormat.JSONLD11),
    TEXT(ResultSetLang.RS_Text, RDFFormat.TURTLE),
    CSV(ResultSetLang.RS_CSV, null),
    TSV(ResultSetLang.RS_TSV, null),
    THRIFT(ResultSetLang.RS_Thrift, RDFFormat.RDF_THRIFT),
    PROTOBUF(ResultSetLang.RS_Protobuf, RDFFormat.RDF_PROTO),
    TTL(null, RDFFormat.TURTLE),
    NT(null, RDFFormat.NTRIPLES),
    RDFXML(null, RDFFormat.RDFXML),
    RDF_JSONLD(null, RDFFormat.JSONLD),
    COUNT(null, null),
    NONE(ResultSetLang.RS_None, RDFFormat.RDFNULL),
    SSE(null, null),
    TUPLES(null, null);

    private final Lang resultSetLang;
    private final RDFFormat rdfFormat;
    private static TranslationTable<ResultsFormat> names;

    private ResultsFormat(Lang resultSetLang, RDFFormat rdfFormat) {
        this.resultSetLang = resultSetLang;
        this.rdfFormat = rdfFormat;
    }

    public Lang resultSetLang() {
        return this.resultSetLang;
    }

    public RDFFormat rdfFormat() {
        return this.rdfFormat;
    }

    public static ResultsFormat guessSyntax(String resultsFilename) {
        ResultsFormat[] enums;
        Lang rsLang = RDFLanguages.pathnameToLang(resultsFilename);
        if (rsLang == null) {
            return null;
        }
        for (ResultsFormat rsFmt : enums = ResultsFormat.values()) {
            if (!rsFmt.resultSetLang().equals(rsLang)) continue;
            return rsFmt;
        }
        return null;
    }

    public static ResultsFormat lookup(String shortname) {
        return names.lookup(shortname);
    }

    static {
        names = new TranslationTable(true);
        names.put("srx", XML);
        names.put("xml", XML);
        names.put("json", JSON);
        names.put("srj", JSON);
        names.put("srt", THRIFT);
        names.put("srp", PROTOBUF);
        names.put("rdfxml", RDFXML);
        names.put("rdf", TTL);
        names.put("ttl", TTL);
        names.put("turtle", TTL);
        names.put("n-triples", NT);
        names.put("ntriples", NT);
        names.put("nt", NT);
        names.put("jsonld", RDF_JSONLD);
        names.put("json-ld", RDF_JSONLD);
        names.put("sse", SSE);
        names.put("csv", CSV);
        names.put("tsv", TSV);
        names.put("text", TEXT);
        names.put("count", COUNT);
        names.put("tuples", TUPLES);
        names.put("none", NONE);
    }
}

