/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;

public class Params {
    public static final String TYPE_ANALYZER = "TypeAnalyzer";
    public static final String TYPE_BOOL = "TypeBoolean";
    public static final String TYPE_FILE = "TypeFile";
    public static final String TYPE_INT = "TypeInt";
    public static final String TYPE_SET = "TypeSet";
    public static final String TYPE_STRING = "TypeString";
    public static final String TYPE_TOKENSTREAM = "TypeTokenStream";

    protected static List<ParamSpec> getParamSpecs(Resource list) {
        ArrayList<ParamSpec> result = new ArrayList<ParamSpec>();
        Resource current = list;
        while (current != null && !current.equals(RDF.nil)) {
            Statement firstStmt = current.getProperty(RDF.first);
            if (firstStmt == null) {
                throw new TextIndexException("parameter list not well formed: " + String.valueOf(current));
            }
            RDFNode first = firstStmt.getObject();
            if (!first.isResource()) {
                throw new TextIndexException("parameter specification must be an anon resource : " + String.valueOf(first));
            }
            result.add(Params.getParamSpec((Resource)first));
            Statement restStmt = current.getProperty(RDF.rest);
            if (restStmt == null) {
                throw new TextIndexException("parameter list not terminated by rdf:nil");
            }
            RDFNode rest = restStmt.getObject();
            if (!rest.isResource()) {
                throw new TextIndexException("parameter list node is not a resource : " + String.valueOf(rest));
            }
            current = (Resource)rest;
        }
        return result;
    }

    protected static ParamSpec getParamSpec(Resource node) {
        Statement nameStmt = node.getProperty(TextVocab.pParamName);
        Statement valueStmt = node.getProperty(TextVocab.pParamValue);
        String name = Params.getStringValue(nameStmt);
        String type = Params.getType(node);
        String value = Params.getStringValue(valueStmt);
        switch (type) {
            case "TypeString": {
                if (value == null) {
                    throw new TextIndexException("Value for string param: " + name + " must not be empty!");
                }
                return new ParamSpec(name, value, String.class);
            }
            case "TypeFile": {
                if (value == null) {
                    throw new TextIndexException("Value for file param must exist and must contain a file name.");
                }
                try {
                    FileReader fileReader = new FileReader(value);
                    return new ParamSpec(name, fileReader, Reader.class);
                }
                catch (FileNotFoundException ex) {
                    throw new TextIndexException("File " + value + " for param " + name + " not found!");
                }
            }
            case "TypeSet": {
                if (valueStmt == null) {
                    throw new TextIndexException("A set param spec must have a text:paramValue:" + String.valueOf(node));
                }
                RDFNode valueNode = valueStmt.getObject();
                if (!valueNode.isResource()) {
                    throw new TextIndexException("A set param spec text:paramValue must be a list of strings: " + String.valueOf(valueNode));
                }
                List<String> values = Params.toStrings((Resource)valueNode);
                return new ParamSpec(name, new CharArraySet(values, false), CharArraySet.class);
            }
            case "TypeInt": {
                if (value == null) {
                    throw new TextIndexException("Value for int param: " + name + " must not be empty!");
                }
                int n = ((Literal)valueStmt.getObject()).getInt();
                return new ParamSpec(name, n, Integer.TYPE);
            }
            case "TypeBoolean": {
                if (value == null) {
                    throw new TextIndexException("Value for boolean param: " + name + " must not be empty!");
                }
                boolean b = ((Literal)valueStmt.getObject()).getBoolean();
                return new ParamSpec(name, b, Boolean.TYPE);
            }
            case "TypeAnalyzer": {
                if (valueStmt == null) {
                    throw new TextIndexException("Analyzer param spec must have a text:paramValue:" + String.valueOf(node));
                }
                RDFNode valueNode = valueStmt.getObject();
                if (!valueNode.isResource()) {
                    throw new TextIndexException("Analyzer param spec text:paramValue must be an analyzer spec resource: " + String.valueOf(valueNode));
                }
                Analyzer analyzer = (Analyzer)Assembler.general().open((Resource)valueNode);
                return new ParamSpec(name, analyzer, Analyzer.class);
            }
        }
        Log.error("org.apache.jena.query.text.assembler.Params", "Unknown parameter type: " + type + " for param: " + name + " with value: " + value);
        return null;
    }

    private static String getType(Resource node) {
        Statement typeStmt = node.getProperty(TextVocab.pParamType);
        Statement valueStmt = node.getProperty(TextVocab.pParamValue);
        String type = null;
        if (typeStmt == null) {
            if (valueStmt == null) {
                throw new TextIndexException("Parameter specification must have a text:paramValue: " + String.valueOf(node));
            }
            RDFNode obj = valueStmt != null ? valueStmt.getObject() : null;
            Literal lit = obj.asLiteral();
            RDFDatatype rdfType = lit.getDatatype();
            Class<?> clazz = rdfType.getJavaClass();
            if (clazz == Boolean.class) {
                type = TYPE_BOOL;
            } else if (clazz == BigInteger.class) {
                type = TYPE_INT;
            } else if (clazz == String.class) {
                type = TYPE_STRING;
            }
        } else {
            Resource typeRes = typeStmt.getResource();
            type = typeRes.getLocalName();
        }
        return type;
    }

    private static String getStringValue(Statement stmt) {
        if (stmt == null) {
            return null;
        }
        RDFNode node = stmt.getObject();
        if (node.isLiteral()) {
            return ((Literal)node).getLexicalForm();
        }
        return null;
    }

    protected static List<String> toStrings(Resource list) {
        ArrayList<String> result = new ArrayList<String>();
        Resource current = list;
        while (current != null && !current.equals(RDF.nil)) {
            Statement firstStmt = current.getProperty(RDF.first);
            if (firstStmt == null) {
                throw new TextIndexException("param spec of type set not well formed");
            }
            RDFNode first = firstStmt.getObject();
            if (!first.isLiteral()) {
                throw new TextIndexException("param spec of type set item is not a literal: " + String.valueOf(first));
            }
            result.add(((Literal)first).getLexicalForm());
            Statement restStmt = current.getProperty(RDF.rest);
            if (restStmt == null) {
                throw new TextIndexException("param spec of type set not terminated by rdf:nil");
            }
            RDFNode rest = restStmt.getObject();
            if (!rest.isResource()) {
                throw new TextIndexException("param spec of type set rest is not a resource: " + String.valueOf(rest));
            }
            current = (Resource)rest;
        }
        return result;
    }

    protected static final class ParamSpec {
        private final String name;
        private final Object value;
        private final Class<?> clazz;

        public ParamSpec(String key, Object value) {
            this(key, value, value.getClass());
        }

        public ParamSpec(String key, Object value, Class<?> clazz) {
            this.name = key;
            this.value = value;
            this.clazz = clazz;
        }

        public String getKey() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Class<?> getValueClass() {
            return this.clazz;
        }
    }
}

