/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.graph.GraphSink;
import org.apache.jena.sparql.graph.GraphTxn;
import org.apache.jena.sparql.graph.GraphZero;
import org.apache.jena.sys.JenaSystem;

public class GraphFactory {
    private static boolean defaultSameTerm;

    @Deprecated
    public static void setDftGraphSameTerm(boolean value) {
        defaultSameTerm = value;
    }

    public static Graph createGraphMem() {
        return GraphMemFactory.createDefaultGraphSameTerm();
    }

    public static GraphTxn createTxnGraph() {
        return new GraphTxn();
    }

    public static Graph emptyGraph() {
        return GraphZero.instance();
    }

    public static Graph createDefaultGraph() {
        return GraphFactory.createJenaDefaultGraph();
    }

    public static Graph createJenaDefaultGraph() {
        return GraphMemFactory.createDefaultGraph();
    }

    public static Graph sinkGraph() {
        return GraphSink.instance();
    }

    public static Model makeJenaDefaultModel() {
        return ModelFactory.createDefaultModel();
    }

    public static Model makeDefaultModel() {
        return ModelFactory.createModelForGraph(GraphFactory.createDefaultGraph());
    }

    static {
        JenaSystem.init();
        defaultSameTerm = true;
        String x = System.getProperty("jena:graphSameTerm");
        if (x != null && x.equalsIgnoreCase("true")) {
            defaultSameTerm = true;
        }
    }
}

