/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.converter;

import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;

final class CharSequenceConverter<T>
extends SystemConverter<CharSequence, T> {
    private static final long serialVersionUID = -2853169224777674260L;
    private final ObjectConverter<? super String, ? extends T> next;

    CharSequenceConverter(Class<T> targetClass, ObjectConverter<? super String, ? extends T> next) {
        super(CharSequence.class, targetClass);
        this.next = next;
    }

    @Override
    public T apply(CharSequence source) throws UnconvertibleObjectException {
        if (this.targetClass.isInstance(source)) {
            return this.targetClass.cast(source);
        }
        return this.next.apply(source != null ? source.toString() : null);
    }

    @Override
    public Set<FunctionProperty> properties() {
        EnumSet<FunctionProperty> properties = EnumSet.copyOf(this.next.properties());
        properties.remove((Object)FunctionProperty.INJECTIVE);
        return properties;
    }
}

