/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.cp.LocalFile;
import org.apache.juneau.internal.HashCode;
import org.apache.juneau.internal.ObjectUtils;

public class LocalDir {
    private final Class<?> clazz;
    private final String clazzPath;
    private final Path path;
    private final int hashCode;

    public LocalDir(Class<?> clazz, String clazzPath) {
        this.clazz = (Class)ArgUtils.assertArgNotNull((String)"clazz", clazz);
        this.clazzPath = "/".equals(clazzPath) ? "/" : StringUtils.nullIfEmpty((String)StringUtils.trimTrailingSlashes((String)clazzPath));
        this.path = null;
        this.hashCode = HashCode.of(clazz, clazzPath);
    }

    public LocalDir(Path path) {
        this.clazz = null;
        this.clazzPath = null;
        this.path = (Path)ArgUtils.assertArgNotNull((String)"path", (Object)path);
        this.hashCode = path.hashCode();
    }

    public LocalFile resolve(String path) {
        if (this.clazz != null) {
            String p;
            String string = this.clazzPath == null ? path : (p = ("/".equals(this.clazzPath) ? "" : this.clazzPath) + "/" + path);
            if (this.isClasspathFile(this.clazz.getResource(p))) {
                return new LocalFile(this.clazz, p);
            }
        } else {
            Path p = this.path.resolve(path);
            if (Files.isReadable(p) && !Files.isDirectory(p, new LinkOption[0])) {
                return new LocalFile(p);
            }
        }
        return null;
    }

    private boolean isClasspathFile(URL url) {
        try {
            if (url == null) {
                return false;
            }
            URI uri = url.toURI();
            if (uri.toString().startsWith("file:") && Files.isDirectory(Paths.get(uri), new LinkOption[0])) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o instanceof LocalDir && ObjectUtils.eq(this, (LocalDir)o, (x, y) -> ObjectUtils.eq(x.clazz, y.clazz) && StringUtils.eq((String)x.clazzPath, (String)y.clazzPath) && ObjectUtils.eq(x.path, y.path));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this.clazz == null) {
            return this.path.toString();
        }
        return this.clazz.getName() + ":" + this.clazzPath;
    }
}

