/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.connection.utils;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.NoExceptionsAreFatalSorter;
import org.ops4j.pax.transx.connection.utils.AbstractConnectionHandle;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnection;
import org.ops4j.pax.transx.connection.utils.UserPasswordConnectionRequestInfo;
import org.ops4j.pax.transx.connection.utils.UserPasswordManagedConnectionFactory;

public abstract class AbstractManagedConnectionFactory<MCF extends AbstractManagedConnectionFactory<MCF, MC, C, CI>, MC extends AbstractManagedConnection<MCF, MC, C, CI>, C, CI extends AbstractConnectionHandle<MCF, MC, C, CI>>
implements UserPasswordManagedConnectionFactory,
ValidatingManagedConnectionFactory,
TransactionSupport {
    protected ExceptionSorter exceptionSorter;
    protected String userName;
    protected String password;

    public AbstractManagedConnectionFactory() {
        this.exceptionSorter = NoExceptionsAreFatalSorter.INSTANCE;
    }

    public AbstractManagedConnectionFactory(ExceptionSorter exceptionSorter) {
        this.exceptionSorter = exceptionSorter;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String user) {
        this.userName = user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getExceptionSorterClass() {
        return this.exceptionSorter.getClass().getName();
    }

    public void setExceptionSorterClass(String className) throws InvalidPropertyException {
        if (className == null || className.length() == 0) {
            throw new InvalidPropertyException("Empty class name");
        }
        try {
            Class<?> clazz = this.loadClass(className);
            this.exceptionSorter = (ExceptionSorter)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPropertyException("Unable to load class: " + className, (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InvalidPropertyException("Unable to instantiate class: " + className, (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new InvalidPropertyException("Class is not a " + ExceptionSorter.class.getName() + ": " + className, (Throwable)e);
        }
    }

    public ExceptionSorter getExceptionSorter() {
        return this.exceptionSorter;
    }

    public void setExceptionSorter(ExceptionSorter exceptionSorter) {
        this.exceptionSorter = exceptionSorter;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(null);
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        for (Object o : set) {
            AbstractManagedConnection mc;
            if (!(o instanceof AbstractManagedConnection) || !(mc = (AbstractManagedConnection)o).getCredentialExtractor().matches(subject, (UserPasswordConnectionRequestInfo)connectionRequestInfo, this)) continue;
            return mc;
        }
        return null;
    }

    public abstract CI createConnectionHandle(ConnectionRequestInfo var1, MC var2);

    public Set getInvalidConnections(Set set) throws ResourceException {
        HashSet newSet = new HashSet();
        for (Object o : set) {
            AbstractManagedConnection mc;
            if (!(o instanceof AbstractManagedConnection) || (mc = (AbstractManagedConnection)o).isValid()) continue;
            newSet.add(o);
        }
        return newSet;
    }

    protected Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoader cl = this.getContextClassLoader();
        if (cl != null) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(name);
    }

    protected ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(() -> {
            try {
                return Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException e) {
                return null;
            }
        });
    }
}

