/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import javax.json.spi.JsonProvider;

public class SerializableValue
implements Serializable {
    private static final AtomicReference<JsonReaderFactory> FACTORY_ATOMIC_REFERENCE = new AtomicReference();
    private final String value;

    SerializableValue(String value) {
        this.value = value;
    }

    private Object readResolve() throws ObjectStreamException {
        try (JsonReader parser = SerializableValue.factory().createReader(new StringReader(this.value));){
            JsonStructure jsonStructure = parser.read();
            return jsonStructure;
        }
    }

    private static JsonReaderFactory factory() {
        JsonReaderFactory factory = FACTORY_ATOMIC_REFERENCE.get();
        if (factory == null) {
            FACTORY_ATOMIC_REFERENCE.compareAndSet(null, JsonProvider.provider().createReaderFactory(Collections.emptyMap()));
            factory = FACTORY_ATOMIC_REFERENCE.get();
        }
        return factory;
    }
}

