/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.pool.impl;

import java.util.ArrayList;
import java.util.Collection;
import net.sf.ehcache.pool.PoolEvictor;
import net.sf.ehcache.pool.PoolableStore;

public abstract class AbstractFromLargestCachePoolEvictor
implements PoolEvictor<PoolableStore> {
    @Override
    public boolean freeSpace(Collection<PoolableStore> from, long bytes) {
        if (from == null || from.isEmpty()) {
            return false;
        }
        long remainingSizeInBytes = bytes;
        ArrayList<PoolableStore> tried = new ArrayList<PoolableStore>();
        while (tried.size() != from.size()) {
            PoolableStore largestPoolableStore = this.findUntriedLargestPoolableStore(from, tried);
            long beforeEvictionSize = this.getSizeInBytes(largestPoolableStore);
            if (!this.evict(1, bytes, largestPoolableStore)) {
                tried.add(largestPoolableStore);
                continue;
            }
            long afterEvictionSize = this.getSizeInBytes(largestPoolableStore);
            if ((remainingSizeInBytes -= beforeEvictionSize - afterEvictionSize) > 0L) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean evict(int var1, long var2, PoolableStore var4);

    protected abstract long getSizeInBytes(PoolableStore var1);

    private PoolableStore findUntriedLargestPoolableStore(Collection<PoolableStore> from, Collection<PoolableStore> tried) {
        PoolableStore largestPoolableStore = null;
        for (PoolableStore poolableStore : from) {
            if (this.alreadyTried(tried, poolableStore) || largestPoolableStore != null && this.getSizeInBytes(poolableStore) <= this.getSizeInBytes(largestPoolableStore)) continue;
            largestPoolableStore = poolableStore;
        }
        return largestPoolableStore;
    }

    private boolean alreadyTried(Collection<PoolableStore> tried, PoolableStore from) {
        for (PoolableStore poolableStore : tried) {
            if (poolableStore != from) continue;
            return true;
        }
        return false;
    }
}

