/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.searchblox;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.ClientBuilder;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.searchblox.Messages;
import org.apache.manifoldcf.agents.output.searchblox.SearchBloxClient;
import org.apache.manifoldcf.agents.output.searchblox.SearchBloxDocument;
import org.apache.manifoldcf.agents.output.searchblox.SearchBloxException;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.apache.manifoldcf.crawler.system.Logging;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class SearchBloxConnector
extends BaseOutputConnector {
    private static final String SEARCHBLOX_TAB_PARAMETERS = "SearchBloxConnector.Parameters";
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_SPECIFICATION_CONFIGURATION_HTML = "editSpecification_Configuration.html";
    private static final String VIEW_SPECIFICATION_HTML = "viewSpecification.html";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration.js";
    private static final String EDIT_CONFIG_FORWARD_PARAMETERS = "editConfiguration_Parameters.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration.html";
    private static final String DEFAULT_COLLECTION = "Custom";
    private static final String DEFAULT_APIKEY = "apiKey";
    public static final String INGEST_ACTIVITY = "document ingest";
    public static final String REMOVE_ACTIVITY = "document deletion";
    public static final String CREATION_ACTIVITY = "collection created";
    private static final String SEARCHBLOX_ENDPOINT = "endpoint";
    private static final String SEARCHBLOX_INDEXING_FORMAT = "indexformat";
    private static final String SEARCHBLOX_SOCKET_TIMEOUT = "sockettimeout";
    private static final String SEARCHBLOX_CONNECTION_TIMEOUT = "connectiontimeout";
    private static final String BUILDER_DEFAULT_SOCKET_TIMEOUT = "60";
    private static final String BUILDER_DEFAULT_CONNECTION_TIMEOUT = "60";
    private SearchBloxClient client = null;
    private String apiKey = null;

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
    }

    public boolean isConnected() {
        return this.client != null;
    }

    public void disconnect() throws ManifoldCFException {
        if (this.client != null) {
            this.apiKey = null;
            this.client = null;
        }
        super.disconnect();
    }

    public String[] getActivitiesList() {
        return new String[]{INGEST_ACTIVITY, REMOVE_ACTIVITY, CREATION_ACTIVITY};
    }

    protected void getSession() throws ManifoldCFException {
        if (this.client == null) {
            long socketTimeout;
            long connectionTimeout;
            String connectionTimeoutString = this.params.getParameter(SEARCHBLOX_CONNECTION_TIMEOUT);
            if (connectionTimeoutString == null) {
                connectionTimeoutString = "60";
            }
            try {
                connectionTimeout = Integer.parseInt(connectionTimeoutString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad connection timeout: " + e.getMessage(), (Throwable)e);
            }
            String socketTimeoutString = this.params.getParameter(SEARCHBLOX_SOCKET_TIMEOUT);
            if (socketTimeoutString == null) {
                socketTimeoutString = "60";
            }
            try {
                socketTimeout = Integer.parseInt(socketTimeoutString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad socket timeout: " + e.getMessage(), (Throwable)e);
            }
            String endpoint = this.params.getParameter(SEARCHBLOX_ENDPOINT);
            this.apiKey = this.params.getParameter("apikey");
            ResteasyClientBuilder builder = new ResteasyClientBuilder();
            builder.connectionPoolSize(1);
            builder.establishConnectionTimeout(connectionTimeout, TimeUnit.SECONDS);
            builder.socketTimeout(socketTimeout, TimeUnit.SECONDS);
            this.client = new SearchBloxClient(this.apiKey, (ClientBuilder)builder, endpoint);
        }
    }

    public String check() throws ManifoldCFException {
        this.getSession();
        try {
            String format = this.getConfiguration().getParameter(SEARCHBLOX_INDEXING_FORMAT);
            if (this.client.ping(format)) {
                return super.check();
            }
            return "Connection Not Working!. Check SearchBlox Server is up and the configuration is correct.";
        }
        catch (SearchBloxException e) {
            Logging.connectors.error((Object)"Connection Not Working", (Throwable)e);
            return "Connection Not Working!" + e.getMessage();
        }
    }

    public VersionContext getPipelineDescription(Specification spec) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(spec);
        return new VersionContext(sp.toPackedString(), this.params, spec);
    }

    public boolean checkMimeTypeIndexable(VersionContext outputDescription, String mimeType, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        return true;
    }

    public boolean checkLengthIndexable(VersionContext outputDescription, long length, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        return true;
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        Logging.connectors.info((Object)("Indexing Document " + documentURI));
        long indexingTime = System.currentTimeMillis();
        SpecPacker sp = new SpecPacker(pipelineDescription.getSpecification());
        Map<String, List<String>> args = sp.getArgs();
        this.getSession();
        SearchBloxDocument sbDoc = new SearchBloxDocument(this.apiKey, documentURI, document, args);
        String format = this.getConfiguration().getParameter(SEARCHBLOX_INDEXING_FORMAT);
        long startTime = System.currentTimeMillis();
        try {
            SearchBloxClient.ResponseCode code = this.client.addUpdateDocument(sbDoc, format);
            if (code == SearchBloxClient.ResponseCode.DOCUMENT_INDEXED) {
                Logging.connectors.info((Object)("Document Indexed" + documentURI));
                activities.recordActivity(Long.valueOf(startTime), INGEST_ACTIVITY, null, documentURI, "OK", "Document Indexed");
            } else {
                activities.recordActivity(Long.valueOf(startTime), INGEST_ACTIVITY, null, documentURI, "" + code.getCode(), code.name());
            }
        }
        catch (SearchBloxException e) {
            Logging.connectors.error((Object)("[Indexing - Add] Exception indexing document :" + String.valueOf(document)), (Throwable)e);
            String activityCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
            String activityDetails = e.getMessage() + (String)(e.getCause() != null ? ": " + e.getCause().getMessage() : "");
            activities.recordActivity(Long.valueOf(startTime), INGEST_ACTIVITY, null, documentURI, activityCode, activityDetails);
            return 1;
        }
        indexingTime = System.currentTimeMillis() - indexingTime;
        Logging.connectors.info((Object)("Indexing Time for document " + documentURI + ": " + indexingTime));
        return 0;
    }

    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        Logging.ingest.debug((Object)("Deleting SearchBlox Document: '" + documentURI + "'"));
        SpecPacker packer = new SpecPacker(outputDescription);
        Map<String, List<String>> args = packer.getArgs();
        this.getSession();
        SearchBloxDocument document = new SearchBloxDocument(this.apiKey);
        document.uid = documentURI;
        document.colName = args.get("collection").get(0);
        String format = this.getConfiguration().getParameter(SEARCHBLOX_INDEXING_FORMAT);
        long startTime = System.currentTimeMillis();
        try {
            SearchBloxClient.ResponseCode code = this.client.deleteDocument(document, format);
            if (code == SearchBloxClient.ResponseCode.DOCUMENT_DELETED) {
                activities.recordActivity(Long.valueOf(startTime), REMOVE_ACTIVITY, null, documentURI, "OK", "Document Deleted");
            } else {
                activities.recordActivity(Long.valueOf(startTime), REMOVE_ACTIVITY, null, documentURI, "" + code.getCode(), code.name());
            }
        }
        catch (SearchBloxException e) {
            Logging.connectors.error((Object)("[Indexing - Remove] Exception indexing document :" + String.valueOf(document)), (Throwable)e);
            String activityCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
            String activityDetails = e.getMessage() + (String)(e.getCause() != null ? ": " + e.getCause().getMessage() : "");
            activities.recordActivity(Long.valueOf(startTime), REMOVE_ACTIVITY, null, documentURI, activityCode, activityDetails);
        }
    }

    private static void outputResource(String resName, IHTTPOutput out, Locale locale, Map<String, String> params, String tabName, Integer sequenceNumber, Integer currentSequenceNumber) throws ManifoldCFException {
        Map<String, String> paramMap = null;
        if (params != null) {
            paramMap = params;
            if (tabName != null) {
                paramMap.put("TabName", tabName);
            }
            if (currentSequenceNumber != null) {
                paramMap.put("SelectedNum", currentSequenceNumber.toString());
            }
        } else {
            paramMap = new HashMap<String, String>();
        }
        if (sequenceNumber != null) {
            paramMap.put("SeqNum", sequenceNumber.toString());
        }
        Messages.outputResourceWithVelocity(out, locale, resName, paramMap, true);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        super.outputConfigurationHeader(threadContext, out, locale, parameters, tabsArray);
        tabsArray.add(Messages.getString(locale, SEARCHBLOX_TAB_PARAMETERS));
        SearchBloxConnector.outputResource(EDIT_CONFIG_HEADER_FORWARD, out, locale, null, null, null, null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        super.outputConfigurationBody(threadContext, out, locale, parameters, tabName);
        Map<String, String> config = this.getConfigParameters(parameters);
        SearchBloxConnector.outputResource(EDIT_CONFIG_FORWARD_PARAMETERS, out, locale, config, tabName, null, null);
    }

    private final Map<String, String> getConfigParameters(ConfigParams configParams) {
        HashMap<String, String> map = new HashMap<String, String>();
        String apiKey = configParams.getParameter("apikey");
        if (apiKey == null) {
            apiKey = DEFAULT_APIKEY;
        }
        map.put("apikey", apiKey);
        String endpoint = configParams.getParameter(SEARCHBLOX_ENDPOINT);
        if (endpoint == null) {
            endpoint = "http://localhost:8080/searchblox/rest/v1/api";
        }
        map.put(SEARCHBLOX_ENDPOINT, endpoint);
        String indexFormat = configParams.getParameter(SEARCHBLOX_INDEXING_FORMAT);
        if (indexFormat == null) {
            indexFormat = SearchBloxDocument.IndexingFormat.JSON.name();
        }
        map.put(SEARCHBLOX_INDEXING_FORMAT, indexFormat);
        String connectionTimeout = configParams.getParameter(SEARCHBLOX_CONNECTION_TIMEOUT);
        if (connectionTimeout == null) {
            connectionTimeout = "60";
        }
        map.put(SEARCHBLOX_CONNECTION_TIMEOUT, connectionTimeout);
        String socketTimeout = configParams.getParameter(SEARCHBLOX_SOCKET_TIMEOUT);
        if (socketTimeout == null) {
            socketTimeout = "60";
        }
        map.put(SEARCHBLOX_SOCKET_TIMEOUT, socketTimeout);
        return map;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        SearchBloxConnector.outputResource(VIEW_CONFIG_FORWARD, out, locale, this.getConfigParameters(parameters), null, null, null);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String socketTimeout;
        String connectionTimeout;
        String indexformat;
        String endpoint;
        String apiKey = variableContext.getParameter("apikey");
        if (apiKey != null) {
            parameters.setParameter("apikey", apiKey);
        }
        if ((endpoint = variableContext.getParameter(SEARCHBLOX_ENDPOINT)) != null) {
            parameters.setParameter(SEARCHBLOX_ENDPOINT, endpoint);
        }
        if ((indexformat = variableContext.getParameter(SEARCHBLOX_INDEXING_FORMAT)) != null) {
            parameters.setParameter(SEARCHBLOX_INDEXING_FORMAT, indexformat);
        }
        if ((connectionTimeout = variableContext.getParameter(SEARCHBLOX_CONNECTION_TIMEOUT)) != null) {
            parameters.setParameter(SEARCHBLOX_CONNECTION_TIMEOUT, connectionTimeout);
        }
        if ((socketTimeout = variableContext.getParameter(SEARCHBLOX_SOCKET_TIMEOUT)) != null) {
            parameters.setParameter(SEARCHBLOX_SOCKET_TIMEOUT, socketTimeout);
        }
        return null;
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "SearchBloxConnector.Configuration"));
        this.fillInSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JS, paramMap);
    }

    private void fillInSpecificationMap(Map<String, Object> paramMap, Specification os) {
        int len = os.getChildCount();
        for (int i = 0; i < len; ++i) {
            String collection;
            String descriptionBoost;
            String keywordsBoost;
            String contentBoost;
            SpecificationNode sn = os.getChild(i);
            if (!sn.getType().equals("configuration")) continue;
            String titleBoost = sn.getAttributeValue("title_boost");
            if (titleBoost == null || titleBoost.isEmpty()) {
                titleBoost = "0";
            }
            if ((contentBoost = sn.getAttributeValue("content_boost")) == null || contentBoost.isEmpty()) {
                contentBoost = "0";
            }
            if ((keywordsBoost = sn.getAttributeValue("keywords_boost")) == null || keywordsBoost.isEmpty()) {
                keywordsBoost = "0";
            }
            if ((descriptionBoost = sn.getAttributeValue("description_boost")) == null || descriptionBoost.isEmpty()) {
                descriptionBoost = "0";
            }
            if ((collection = sn.getAttributeValue("collection")) == null) {
                collection = DEFAULT_COLLECTION;
            }
            paramMap.put("title_boost".toUpperCase(Locale.ROOT), titleBoost);
            paramMap.put("content_boost".toUpperCase(Locale.ROOT), contentBoost);
            paramMap.put("keywords_boost".toUpperCase(Locale.ROOT), keywordsBoost);
            paramMap.put("description_boost".toUpperCase(Locale.ROOT), descriptionBoost);
            paramMap.put("collection".toUpperCase(Locale.ROOT), collection);
            return;
        }
        paramMap.put("title_boost".toUpperCase(Locale.ROOT), 0);
        paramMap.put("content_boost".toUpperCase(Locale.ROOT), 0);
        paramMap.put("keywords_boost".toUpperCase(Locale.ROOT), 0);
        paramMap.put("description_boost".toUpperCase(Locale.ROOT), 0);
        paramMap.put(SEARCHBLOX_INDEXING_FORMAT.toUpperCase(Locale.ROOT), SearchBloxDocument.IndexingFormat.XML.name());
        paramMap.put("collection".toUpperCase(Locale.ROOT), "");
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        this.fillInSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_HTML, paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        paramMap.put("SELECTEDNUM", Integer.toString(actualSequenceNumber));
        this.fillInSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_CONFIGURATION_HTML, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        SpecificationNode node;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String titleBoost = variableContext.getParameter(seqPrefix + "title_boost");
        String contentBoost = variableContext.getParameter(seqPrefix + "content_boost");
        String keywordsBoost = variableContext.getParameter(seqPrefix + "keywords_boost");
        String descriptionBoost = variableContext.getParameter(seqPrefix + "description_boost");
        String collection = variableContext.getParameter(seqPrefix + "collection");
        String indexFormat = variableContext.getParameter(seqPrefix + SEARCHBLOX_INDEXING_FORMAT);
        int i = 0;
        int len = os.getChildCount();
        while (i < len) {
            node = os.getChild(i);
            if (node.getType().equals("configuration")) {
                os.removeChild(i);
                continue;
            }
            ++i;
        }
        node = new SpecificationNode("configuration");
        node.setAttribute("title_boost", titleBoost);
        node.setAttribute("content_boost", contentBoost);
        node.setAttribute("keywords_boost", keywordsBoost);
        node.setAttribute("description_boost", descriptionBoost);
        node.setAttribute("collection", collection);
        node.setAttribute(SEARCHBLOX_INDEXING_FORMAT, indexFormat);
        os.addChild(os.getChildCount(), (ConfigurationNode)node);
        return null;
    }

    protected static class SpecPacker {
        private final Multimap<String, String> args = HashMultimap.create();

        public SpecPacker(String outputDescription) {
            String[] parts;
            for (String part : parts = outputDescription.split(",")) {
                String[] keyValue = part.split("=");
                if (keyValue.length != 2) continue;
                this.args.put((Object)keyValue[0], (Object)keyValue[1]);
            }
        }

        public SpecPacker(Specification spec) {
            for (int i = 0; i < spec.getChildCount(); ++i) {
                SpecificationNode node = spec.getChild(i);
                if (!node.getType().equals("configuration")) continue;
                String titleBoost = node.getAttributeValue("title_boost");
                String contentBoost = node.getAttributeValue("content_boost");
                String keywordsBoost = node.getAttributeValue("keywords_boost");
                String descriptionBoost = node.getAttributeValue("description_boost");
                String collection = node.getAttributeValue("collection");
                this.args.put((Object)"title_boost", (Object)titleBoost);
                this.args.put((Object)"content_boost", (Object)contentBoost);
                this.args.put((Object)"keywords_boost", (Object)keywordsBoost);
                this.args.put((Object)"description_boost", (Object)descriptionBoost);
                this.args.put((Object)"collection", (Object)collection);
            }
        }

        public String toPackedString() {
            Map<String, List<String>> mapList = this.getArgs();
            StringBuilder sb = new StringBuilder();
            for (String s : mapList.keySet()) {
                sb.append(s).append("=").append(mapList.get(s).get(0));
                sb.append(",");
            }
            if (sb.toString().length() != 0) {
                return sb.substring(0, sb.length() - 1);
            }
            return "";
        }

        public Map<String, List<String>> getArgs() {
            HashMap result = Maps.newHashMap();
            for (String s : this.args.keySet()) {
                Collection list = this.args.get((Object)s);
                if (list instanceof List) {
                    result.put(s, (List)list);
                    continue;
                }
                ArrayList l = Lists.newArrayList((Iterable)list);
                result.put(s, l);
            }
            return result;
        }
    }
}

