/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.cache.invalidating;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.DefaultPluginArtifactsCache;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.plugin.PluginResolutionException;
import org.eclipse.sisu.Priority;
import org.mvndaemon.mvnd.cache.Cache;
import org.mvndaemon.mvnd.cache.CacheFactory;
import org.mvndaemon.mvnd.cache.CacheRecord;

@Singleton
@Named
@Priority(value=10)
public class InvalidatingPluginArtifactsCache
extends DefaultPluginArtifactsCache {
    final Cache<PluginArtifactsCache.Key, Record> cache;

    @Inject
    public InvalidatingPluginArtifactsCache(CacheFactory cacheFactory) {
        this.cache = cacheFactory.newCache();
    }

    public PluginArtifactsCache.CacheRecord get(PluginArtifactsCache.Key key) throws PluginResolutionException {
        Record r = this.cache.get(key);
        if (r != null) {
            if (r.record.getException() != null) {
                throw r.record.getException();
            }
            return r.record;
        }
        return null;
    }

    public PluginArtifactsCache.CacheRecord put(PluginArtifactsCache.Key key, List<Artifact> pluginArtifacts) {
        PluginArtifactsCache.CacheRecord record = super.put(key, pluginArtifacts);
        ((DefaultPluginArtifactsCache)this).cache.remove(key);
        this.cache.put(key, new Record(record));
        return record;
    }

    public PluginArtifactsCache.CacheRecord put(PluginArtifactsCache.Key key, PluginResolutionException exception) {
        PluginArtifactsCache.CacheRecord record = super.put(key, exception);
        ((DefaultPluginArtifactsCache)this).cache.remove(key);
        this.cache.put(key, new Record(record));
        return record;
    }

    protected void assertUniqueKey(PluginArtifactsCache.Key key) {
        if (this.cache.get(key) != null) {
            throw new IllegalStateException("Duplicate artifact resolution result for plugin " + key);
        }
    }

    public void flush() {
        this.cache.clear();
    }

    protected static class Record
    implements CacheRecord {
        private final PluginArtifactsCache.CacheRecord record;

        public Record(PluginArtifactsCache.CacheRecord record) {
            this.record = record;
        }

        @Override
        public Stream<Path> getDependencyPaths() {
            if (this.record.getException() != null) {
                return Stream.empty();
            }
            return this.record.getArtifacts().stream().map(artifact -> artifact.getFile().toPath());
        }

        @Override
        public void invalidate() {
        }
    }
}

